/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.service;

import com.flowingcode.backendcore.model.ErrorDescription;
import com.flowingcode.backendcore.model.QuerySpec;
import com.flowingcode.backendcore.service.ConstraintSpecification;
import com.flowingcode.backendcore.service.CrudService;
import com.flowingcode.backendcore.service.validation.CreationValidator;
import com.flowingcode.backendcore.service.validation.DeletionValidator;
import com.flowingcode.backendcore.service.validation.UpdateValidator;
import com.flowingcode.backendcore.validation.CreationValidationException;
import com.flowingcode.backendcore.validation.DeletionValidationException;
import com.flowingcode.backendcore.validation.UpdateValidationException;
import com.flowingcode.backendcore.validation.ValidationException;
import com.flowingcode.backendcore.validation.ValidationSupport;
import com.flowingcode.backendcore.validation.Validator;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.util.Streamable;

public abstract class JpaCrudService<T, K>
implements CrudService<T, K> {
    protected abstract CrudRepository<T, K> getCrudRepository();

    protected abstract JpaSpecificationExecutor<T> getExecutor();

    protected Specification<T> buildSpecification(QuerySpec spec) {
        return ConstraintSpecification.buildSpecification(spec);
    }

    protected K getId(T entity) {
        Object id;
        try {
            Method m = entity.getClass().getMethod("getId", new Class[0]);
            id = m.invoke(entity, new Object[0]);
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e, String.format("Problem when trying to obtain id of entity of type %s by assuming that its name is 'id'", entity.getClass().getName()));
        }
        return (K)id;
    }

    private Sort buildSort(QuerySpec filter) {
        if (filter.getOrders() == null || filter.getOrders().isEmpty()) {
            return Sort.unsorted();
        }
        return Sort.by(filter.getOrders().entrySet().stream().map(e -> {
            switch ((QuerySpec.Order)e.getValue()) {
                case ASC: {
                    return Sort.Order.asc((String)((String)e.getKey()));
                }
                case DESC: {
                    return Sort.Order.desc((String)((String)e.getKey()));
                }
            }
            throw new AssertionError();
        }).collect(Collectors.toList()));
    }

    private Pageable buildPageable(QuerySpec filter) {
        if (filter.getMaxResult() == null) {
            throw new IllegalArgumentException("QuerySpec is not pageable");
        }
        int firstResult = Optional.ofNullable(filter.getFirstResult()).orElse(0);
        int firstPage = firstResult / filter.getMaxResult();
        if (firstResult % filter.getMaxResult() != 0) {
            throw new IllegalArgumentException("QuerySpec is not pageable");
        }
        Sort sort = this.buildSort(filter);
        return PageRequest.of((int)firstPage, (int)filter.getMaxResult(), (Sort)sort);
    }

    public Optional<T> findById(K id) {
        return this.getCrudRepository().findById(id);
    }

    public List<T> findAll() {
        return Streamable.of((Iterable)this.getCrudRepository().findAll()).toList();
    }

    public List<T> filter(QuerySpec filter) {
        if (filter.getFirstResult() == null && filter.getMaxResult() == null) {
            return this.getExecutor().findAll(this.buildSpecification(filter), this.buildSort(filter));
        }
        if (filter.getMaxResult().equals(0)) {
            return Collections.emptyList();
        }
        return this.getExecutor().findAll(this.buildSpecification(filter), this.buildPageable(filter)).toList();
    }

    public long count(QuerySpec filter) {
        return this.getExecutor().count(this.buildSpecification(filter));
    }

    private List<Validator<T>> getValidators(Class<? extends Validator> validatorType) {
        if (this instanceof ValidationSupport) {
            List validators = ((ValidationSupport)this).getValidators(validatorType);
            return validators;
        }
        return Collections.emptyList();
    }

    private void validate(Class<? extends Validator> validatorType, T entity, Function<List<ErrorDescription>, ValidationException> newException) {
        List errors;
        List<Validator<T>> validators = this.getValidators(validatorType);
        if (!validators.isEmpty() && !(errors = validators.stream().flatMap(val -> val.validate(entity).stream()).collect(Collectors.toList())).isEmpty()) {
            throw newException.apply(errors);
        }
    }

    public K save(T entity) {
        this.validate(CreationValidator.class, entity, CreationValidationException::new);
        return this.getId(this.getCrudRepository().save(entity));
    }

    public void update(T entity) {
        this.validate(UpdateValidator.class, entity, UpdateValidationException::new);
        this.getCrudRepository().save(entity);
    }

    public void delete(T entity) {
        this.validate(DeletionValidator.class, entity, DeletionValidationException::new);
        this.getCrudRepository().delete(entity);
    }

    public void deleteById(K id) {
        if (this.getValidators(DeletionValidator.class).isEmpty()) {
            this.getCrudRepository().deleteById(id);
        } else {
            this.findById(id).ifPresent(entity -> {
                this.validate(DeletionValidator.class, entity, DeletionValidationException::new);
                this.getCrudRepository().delete(entity);
            });
        }
    }
}

