/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.service;

import com.flowingcode.backendcore.dao.CreationDao;
import com.flowingcode.backendcore.dao.CrudDao;
import com.flowingcode.backendcore.dao.DeletionDao;
import com.flowingcode.backendcore.dao.QueryDao;
import com.flowingcode.backendcore.dao.UpdateDao;
import com.flowingcode.backendcore.service.CreationServiceMixin;
import com.flowingcode.backendcore.service.CrudService;
import com.flowingcode.backendcore.service.DeletionServiceMixin;
import com.flowingcode.backendcore.service.QueryServiceMixin;
import com.flowingcode.backendcore.service.UpdateServiceMixin;
import com.flowingcode.backendcore.service.validation.DeletionValidator;
import com.flowingcode.backendcore.validation.DeletionValidationException;
import com.flowingcode.backendcore.validation.ValidationSupport;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.stream.Collectors;

public interface CrudServiceMixin<T, K>
extends CreationServiceMixin<T, K>,
UpdateServiceMixin<T>,
DeletionServiceMixin<T>,
QueryServiceMixin<T, K>,
CrudService<T, K> {
    @Override
    default public CreationDao<T, K> getCreationDao() {
        return this.getCrudDao();
    }

    @Override
    default public UpdateDao<T> getUpdateDao() {
        return this.getCrudDao();
    }

    @Override
    default public DeletionDao<T> getDeletionDao() {
        return this.getCrudDao();
    }

    @Override
    default public QueryDao<T, K> getQueryDao() {
        return this.getCrudDao();
    }

    public CrudDao<T, K> getCrudDao();

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={Exception.class})
    default public void deleteById(K id) {
        this.getQueryDao().findById(id).ifPresent(entity -> {
            List validators;
            List errors;
            if (this instanceof ValidationSupport && !(errors = (validators = ((ValidationSupport)this).getValidators(DeletionValidator.class)).stream().flatMap(val -> val.validate(entity).stream()).collect(Collectors.toList())).isEmpty()) {
                throw new DeletionValidationException(errors);
            }
            this.getDeletionDao().delete(entity);
        });
    }
}

