/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.service;

import com.flowingcode.backendcore.dao.UpdateDao;
import com.flowingcode.backendcore.service.BusinessConversionSupport;
import com.flowingcode.backendcore.service.UpdateService;
import com.flowingcode.backendcore.service.validation.UpdateValidator;
import com.flowingcode.backendcore.validation.UpdateValidationException;
import com.flowingcode.backendcore.validation.ValidationException;
import com.flowingcode.backendcore.validation.ValidationSupport;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.stream.Collectors;

public interface ConversionUpdateServiceMixin<B, P>
extends UpdateService<B>,
BusinessConversionSupport<B, P> {
    public UpdateDao<P> getUpdateDao();

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={Exception.class, ValidationException.class})
    default public void update(B entity) {
        List validators;
        List errors;
        if (this instanceof ValidationSupport && !(errors = (validators = ((ValidationSupport)this).getValidators(UpdateValidator.class)).stream().flatMap(val -> val.validate(entity).stream()).collect(Collectors.toList())).isEmpty()) {
            throw new UpdateValidationException(errors);
        }
        this.getUpdateDao().update(this.convertToPersistence(entity));
    }
}

