/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.service;

import com.flowingcode.backendcore.dao.QueryDao;
import com.flowingcode.backendcore.model.QuerySpec;
import com.flowingcode.backendcore.service.BusinessConversionSupport;
import com.flowingcode.backendcore.service.QueryService;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public interface ConversionQueryServiceMixin<B, P, K>
extends QueryService<B, K>,
BusinessConversionSupport<B, P> {
    public QueryDao<P, K> getQueryDao();

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={Exception.class})
    default public Optional<B> findById(K id) {
        return Optional.ofNullable(id).flatMap(arg_0 -> this.getQueryDao().findById(arg_0)).map(this::convertToBusiness);
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={Exception.class})
    default public List<B> findAll() {
        return this.getQueryDao().findAll().stream().map(this::convertToBusiness).collect(Collectors.toList());
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={Exception.class})
    default public List<B> filter(QuerySpec filter) {
        return this.getQueryDao().filter(filter).stream().map(this::convertToBusiness).collect(Collectors.toList());
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={Exception.class})
    default public Optional<B> filterWithSingleResult(QuerySpec filter) {
        return this.getQueryDao().filterWithSingleResult(filter).map(this::convertToBusiness);
    }

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={Exception.class})
    default public long count(QuerySpec filter) {
        return this.getQueryDao().count(filter);
    }
}

