/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.service;

import com.flowingcode.backendcore.dao.CreationDao;
import com.flowingcode.backendcore.service.BusinessConversionSupport;
import com.flowingcode.backendcore.service.CreationService;
import com.flowingcode.backendcore.service.validation.CreationValidator;
import com.flowingcode.backendcore.validation.CreationValidationException;
import com.flowingcode.backendcore.validation.ValidationException;
import com.flowingcode.backendcore.validation.ValidationSupport;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.stream.Collectors;

public interface ConversionCreationServiceMixin<B, P, K>
extends CreationService<B, K>,
BusinessConversionSupport<B, P> {
    public CreationDao<P, K> getCreationDao();

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={Exception.class, ValidationException.class})
    default public K save(B entity) {
        List validators;
        List errors;
        if (this instanceof ValidationSupport && !(errors = (validators = ((ValidationSupport)this).getValidators(CreationValidator.class)).stream().flatMap(val -> val.validate(entity).stream()).collect(Collectors.toList())).isEmpty()) {
            throw new CreationValidationException(errors);
        }
        return (K)this.getCreationDao().save(this.convertToPersistence(entity));
    }
}

