/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.service.validation;

import com.flowingcode.backendcore.model.ErrorDescription;
import com.flowingcode.backendcore.validation.Validator;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;

public interface CreationValidator<T>
extends Validator<T> {
    default public CreationValidator<T> and(CreationValidator<T> then) {
        return t -> {
            List result = this.validate(t);
            if (result.isEmpty()) {
                result = then.validate(t);
            }
            return result;
        };
    }

    public static <T> CreationValidator<T> forCondition(Predicate<T> predicate, Function<T, ErrorDescription> errorSupplier) {
        Objects.requireNonNull(predicate);
        Objects.requireNonNull(errorSupplier);
        return t -> predicate.test(t) ? Validator.success() : Collections.singletonList((ErrorDescription)errorSupplier.apply(t));
    }

    public static <T> CreationValidator<T> forCondition(Predicate<T> predicate, String messageKey) {
        Objects.requireNonNull(messageKey);
        return CreationValidator.forCondition(predicate, (T t) -> new ErrorDescription(messageKey));
    }
}

