/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.backendcore.service;

import com.flowingcode.backendcore.dao.CreationDao;
import com.flowingcode.backendcore.dao.CrudDao;
import com.flowingcode.backendcore.dao.DeletionDao;
import com.flowingcode.backendcore.dao.QueryDao;
import com.flowingcode.backendcore.dao.UpdateDao;
import com.flowingcode.backendcore.service.ConversionCreationServiceMixin;
import com.flowingcode.backendcore.service.ConversionDeletionServiceMixin;
import com.flowingcode.backendcore.service.ConversionQueryServiceMixin;
import com.flowingcode.backendcore.service.ConversionUpdateServiceMixin;
import com.flowingcode.backendcore.service.CrudService;
import com.flowingcode.backendcore.service.validation.DeletionValidator;
import com.flowingcode.backendcore.validation.DeletionValidationException;
import com.flowingcode.backendcore.validation.ValidationSupport;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.stream.Collectors;

public interface ConversionCrudServiceMixin<B, P, K>
extends ConversionCreationServiceMixin<B, P, K>,
ConversionUpdateServiceMixin<B, P>,
ConversionDeletionServiceMixin<B, P>,
ConversionQueryServiceMixin<B, P, K>,
CrudService<B, K> {
    @Override
    default public CreationDao<P, K> getCreationDao() {
        return this.getCrudDao();
    }

    @Override
    default public UpdateDao<P> getUpdateDao() {
        return this.getCrudDao();
    }

    @Override
    default public DeletionDao<P> getDeletionDao() {
        return this.getCrudDao();
    }

    @Override
    default public QueryDao<P, K> getQueryDao() {
        return this.getCrudDao();
    }

    public CrudDao<P, K> getCrudDao();

    @Transactional(value=Transactional.TxType.REQUIRED, rollbackOn={Exception.class})
    default public void deleteById(K id) {
        Object persistentEntity = this.getQueryDao().findById(id).orElse(null);
        if (persistentEntity != null && this instanceof ValidationSupport) {
            Object entity = this.convertToBusiness(persistentEntity);
            List validators = ((ValidationSupport)this).getValidators(DeletionValidator.class);
            List errors = validators.stream().flatMap(val -> val.validate(entity).stream()).collect(Collectors.toList());
            if (!errors.isEmpty()) {
                throw new DeletionValidationException(errors);
            }
            this.getDeletionDao().delete(persistentEntity);
        }
    }
}

