/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.xterm.utils;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class StateMemoizer
implements Serializable {
    private final Map<String, Serializable> setterCalls = new HashMap<String, Serializable>();
    private final Object delegate;
    private final Object proxy;

    public StateMemoizer(Object delegate, Class<?> ... interfaces) {
        this.delegate = Objects.requireNonNull(delegate);
        this.proxy = Proxy.newProxyInstance(interfaces[0].getClassLoader(), interfaces, (proxy, method, args) -> {
            if (method.getName().startsWith("set") && args.length == 1) {
                this.setterCalls.put(method.getName(), (Serializable)args[0]);
            }
            return method.invoke(delegate, args);
        });
    }

    public Object getProxy() {
        return this.proxy;
    }

    public void apply() {
        this.setterCalls.forEach((k, v) -> {
            Method method = Arrays.stream(this.delegate.getClass().getMethods()).filter(it -> it.getName().equals(k)).findAny().get();
            try {
                method.invoke(this.delegate, v);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

