/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.xterm;

import com.flowingcode.vaadin.addons.xterm.ITerminal;
import com.flowingcode.vaadin.addons.xterm.ITerminalOptions;
import com.flowingcode.vaadin.addons.xterm.TerminalAddon;
import com.flowingcode.vaadin.addons.xterm.TerminalTheme;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyLocation;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonArray;
import elemental.json.JsonNull;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;

@NpmPackage(value="xterm", version="5.1.0")
@JsModule(value="./fc-xterm/xterm-element.ts")
@CssImport(value="xterm/css/xterm.css")
public abstract class XTermBase
extends Component
implements ITerminal,
ITerminalOptions,
HasSize,
HasEnabled {
    private ITerminalOptions terminalOptionsProxy;
    private ITerminal terminalProxy;
    private List<Command> deferredCommands;
    private final List<TerminalAddon> addons = new ArrayList<TerminalAddon>();
    private static final Class<?> optionsProxyClass = Proxy.getProxyClass(XTermBase.class.getClassLoader(), ITerminal.class, ITerminalOptions.class);

    public XTermBase() {
        try {
            Object proxy = optionsProxyClass.getConstructor(InvocationHandler.class).newInstance(new ProxyInvocationHandler());
            this.terminalProxy = (ITerminal)proxy;
            this.terminalOptionsProxy = (ITerminalOptions)proxy;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        Element div = new Element("div");
        div.setAttribute("slot", "terminal-container");
        div.getStyle().set("width", "100%");
        div.getStyle().set("height", "100%");
        this.getElement().appendChild(new Element[]{div});
        this.deferredCommands = new LinkedList<Command>();
        Registration[] r = new Registration[]{this.getElement().addEventListener("terminal-initialized", (DomEventListener & Serializable)ev -> this.afterInitialization())};
    }

    private void afterInitialization() {
        if (this.deferredCommands != null) {
            List<Command> deferredCommands = this.deferredCommands;
            this.deferredCommands = null;
            deferredCommands.forEach(Command::execute);
        }
    }

    private CompletableFuture<JsonValue> executeJs(boolean hasResult, String expression, Serializable ... parameters) {
        if (!hasResult) {
            this.executeJs(expression, parameters);
            return CompletableFuture.completedFuture(null);
        }
        if (this.deferredCommands == null) {
            return this.getElement().executeJs(expression, parameters).toCompletableFuture();
        }
        throw new IllegalStateException("Terminal is not initialized");
    }

    protected void executeJs(String expression, Serializable ... parameters) {
        if (this.deferredCommands == null) {
            this.getElement().executeJs(expression, parameters);
        } else {
            this.deferredCommands.add((Command & Serializable)() -> this.getElement().executeJs(expression, parameters));
        }
    }

    public Registration addCustomKeyListener(DomEventListener listener, Key key, KeyModifier ... modifiers) {
        return this.addCustomKeyListener(listener, key, (KeyLocation)null, modifiers);
    }

    public Registration addCustomKeyListener(DomEventListener listener, Key key, KeyLocation location, KeyModifier ... modifiers) {
        return this.addCustomKeyListener(listener, key.getKeys(), location, new HashSet<KeyModifier>(Arrays.asList(modifiers)));
    }

    private Registration addCustomKeyListener(DomEventListener listener, List<String> keys, KeyLocation location, Set<KeyModifier> modifiers) {
        JsonArray array = Json.createArray();
        for (String key : keys) {
            JsonObject json = Json.createObject();
            json.put("code", key);
            if (location != null) {
                json.put("location", (double)location.getLocation());
            }
            json.put("ctrlKey", modifiers.contains(KeyModifier.CONTROL));
            json.put("altKey", modifiers.contains(KeyModifier.ALT));
            json.put("metaKey", modifiers.contains(KeyModifier.META));
            json.put("shiftKey", modifiers.contains(KeyModifier.SHIFT));
            array.set(array.length(), (JsonValue)json);
        }
        StringBuilder sb = new StringBuilder("");
        sb.append(IntStream.range(0, array.length()).mapToObj(i -> array.getObject(i).getString("code")).map(s -> String.format("'%s'", s)).collect(Collectors.joining(",", "[", "]"))).append(".includes(event.detail.code)");
        JsonObject json = array.getObject(0);
        if (location != null) {
            sb.append(" && event.detail.location=").append(json.getNumber("location"));
        }
        for (String modifier : Arrays.asList("ctrlKey", "altKey", "metaKey", "shiftKey")) {
            sb.append(json.getBoolean(modifier) ? "&& " : "&& !").append("event.detail.").append(modifier);
        }
        String filter = sb.toString();
        DomListenerRegistration r = this.getElement().addEventListener("CustomKey", listener).setFilter(filter);
        this.executeJs("this.registerCustomKeyListener($0)", new Serializable[]{json});
        return () -> ((Registration)r).remove();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public <T extends TerminalAddon> T getAddon(Class<? extends T> clazz) {
        return (T)((TerminalAddon)this.addons.stream().filter(clazz::isInstance).map(clazz::cast).findFirst().orElse(null));
    }

    final <T extends TerminalAddon> void registerServerSideAddon(T addon) {
        if (this.getAddon(addon.getClass()) != null) {
            throw new IllegalStateException("Addon already registered: " + addon.getClass().getName());
        }
        this.addons.add(addon);
    }

    @Override
    @Generated
    public void setBellSound(String value) {
        this.terminalOptionsProxy.setBellSound(value);
    }

    @Override
    @Generated
    public void setBellStyle(ITerminalOptions.BellStyle value) {
        this.terminalOptionsProxy.setBellStyle(value);
    }

    @Override
    @Generated
    public void setCursorBlink(boolean value) {
        this.terminalOptionsProxy.setCursorBlink(value);
    }

    @Override
    @Generated
    public void setCursorStyle(ITerminalOptions.CursorStyle value) {
        this.terminalOptionsProxy.setCursorStyle(value);
    }

    @Override
    @Generated
    public void setCursorWidth(int value) {
        this.terminalOptionsProxy.setCursorWidth(value);
    }

    @Override
    @Generated
    public void setDrawBoldTextInBrightColors(boolean value) {
        this.terminalOptionsProxy.setDrawBoldTextInBrightColors(value);
    }

    @Override
    @Generated
    public void setFastScrollModifier(ITerminalOptions.FastScrollModifier value) {
        this.terminalOptionsProxy.setFastScrollModifier(value);
    }

    @Override
    @Generated
    public void setFastScrollSensitivity(int number) {
        this.terminalOptionsProxy.setFastScrollSensitivity(number);
    }

    @Override
    @Generated
    public void setFontSize(int number) {
        this.terminalOptionsProxy.setFontSize(number);
    }

    @Override
    @Generated
    public void setFontFamily(String fontFamily) {
        this.terminalOptionsProxy.setFontFamily(fontFamily);
    }

    @Override
    @Generated
    public void setFontWeight(int value) {
        this.terminalOptionsProxy.setFontWeight(value);
    }

    @Override
    @Generated
    public void setFontWeightBold(int value) {
        this.terminalOptionsProxy.setFontWeightBold(value);
    }

    @Override
    @Generated
    public void setLetterSpacing(int value) {
        this.terminalOptionsProxy.setLetterSpacing(value);
    }

    @Override
    @Generated
    public void setLineHeight(int value) {
        this.terminalOptionsProxy.setLineHeight(value);
    }

    @Override
    @Generated
    public void setMacOptionIsMeta(boolean value) {
        this.terminalOptionsProxy.setMacOptionIsMeta(value);
    }

    @Override
    @Generated
    public void setMacOptionClickForcesSelection(boolean value) {
        this.terminalOptionsProxy.setMacOptionClickForcesSelection(value);
    }

    @Override
    @Generated
    public void setMinimumContrastRatio(int value) {
        this.terminalOptionsProxy.setMinimumContrastRatio(value);
    }

    @Override
    @Generated
    public void setTheme(TerminalTheme theme) {
        this.terminalOptionsProxy.setTheme(theme);
    }

    @Override
    @Generated
    public void setRendererType(ITerminalOptions.RendererType value) {
        this.terminalOptionsProxy.setRendererType(value);
    }

    @Override
    @Generated
    public void setRightClickSelectsWord(boolean value) {
        this.terminalOptionsProxy.setRightClickSelectsWord(value);
    }

    @Override
    @Generated
    public void setScreenReaderMode(boolean value) {
        this.terminalOptionsProxy.setScreenReaderMode(value);
    }

    @Override
    @Generated
    public void setScrollback(int value) {
        this.terminalOptionsProxy.setScrollback(value);
    }

    @Override
    @Generated
    public void setScrollSensitivity(int value) {
        this.terminalOptionsProxy.setScrollSensitivity(value);
    }

    @Override
    @Generated
    public void setTabStopWidth(int value) {
        this.terminalOptionsProxy.setTabStopWidth(value);
    }

    @Override
    @Generated
    public void setWordSeparator(String value) {
        this.terminalOptionsProxy.setWordSeparator(value);
    }

    @Override
    @Generated
    public void blur() {
        this.terminalProxy.blur();
    }

    @Override
    @Generated
    public void focus() {
        this.terminalProxy.focus();
    }

    @Override
    @Generated
    public CompletableFuture<Boolean> hasSelection() {
        return this.terminalProxy.hasSelection();
    }

    @Override
    @Generated
    public CompletableFuture<String> getSelection() {
        return this.terminalProxy.getSelection();
    }

    @Override
    @Generated
    public void clearSelection() {
        this.terminalProxy.clearSelection();
    }

    @Override
    @Generated
    public void select(int column, int row, int length) {
        this.terminalProxy.select(column, row, length);
    }

    @Override
    @Generated
    public void selectAll() {
        this.terminalProxy.selectAll();
    }

    @Override
    @Generated
    public void selectLines(int start, int end) {
        this.terminalProxy.selectLines(start, end);
    }

    @Override
    @Generated
    public void scrollLines(int amount) {
        this.terminalProxy.scrollLines(amount);
    }

    @Override
    @Generated
    public void scrollPages(int pageCount) {
        this.terminalProxy.scrollPages(pageCount);
    }

    @Override
    @Generated
    public void scrollToTop() {
        this.terminalProxy.scrollToTop();
    }

    @Override
    @Generated
    public void scrollToBottom() {
        this.terminalProxy.scrollToBottom();
    }

    @Override
    @Generated
    public void scrollToLine(int line) {
        this.terminalProxy.scrollToLine(line);
    }

    @Override
    @Generated
    public void clear() {
        this.terminalProxy.clear();
    }

    @Override
    @Generated
    public void write(String data) {
        this.terminalProxy.write(data);
    }

    @Override
    @Generated
    public void writeln(String data) {
        this.terminalProxy.writeln(data);
    }

    @Override
    @Generated
    public void paste(String data) {
        this.terminalProxy.paste(data);
    }

    @Override
    @Generated
    public void refresh(int start, int end) {
        this.terminalProxy.refresh(start, end);
    }

    @Override
    @Generated
    public void reset() {
        this.terminalProxy.reset();
    }

    @Override
    @Generated
    public void resize(int columns, int rows) {
        this.terminalProxy.resize(columns, rows);
    }

    private class ProxyInvocationHandler
    implements InvocationHandler,
    Serializable {
        private ProxyInvocationHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, args);
            }
            Function<JsonValue, Object> mapping = this.getResultTypeMapper(method);
            String name = method.getName();
            CompletableFuture<JsonValue> result = this.invoke(mapping != null, name, args);
            if (mapping != null) {
                return result.thenApply(json -> json instanceof JsonNull ? null : mapping.apply((JsonValue)json));
            }
            return null;
        }

        private Function<JsonValue, Object> getResultTypeMapper(Method method) {
            if (method.getReturnType() == Void.TYPE) {
                return null;
            }
            if (method.getReturnType() == CompletableFuture.class) {
                ParameterizedType type = (ParameterizedType)method.getGenericReturnType();
                Class resultType = (Class)type.getActualTypeArguments()[0];
                if (resultType == Void.class) {
                    return x -> null;
                }
                if (resultType == String.class) {
                    return JsonValue::asString;
                }
                if (resultType == Boolean.class) {
                    return JsonValue::asBoolean;
                }
                if (resultType == Integer.class) {
                    return json -> (int)json.asNumber();
                }
                throw new AbstractMethodError(method.toString());
            }
            throw new AbstractMethodError(method.toString());
        }

        private CompletableFuture<JsonValue> invoke(boolean hasResult, String name, Object[] args) {
            if (((String)name).startsWith("set") && args.length == 1) {
                name = ((String)name).substring("set".length());
                name = ((String)name).substring(0, 1).toLowerCase(Locale.ENGLISH) + ((String)name).substring(1);
                Object arg = args[0] instanceof Enum ? ((Enum)args[0]).name().toLowerCase(Locale.ENGLISH) : (args[0] instanceof TerminalTheme ? ((TerminalTheme)args[0]).asJsonObject() : (Serializable)args[0]);
                if (((String)name).equals("bellStyle") || ((String)name).equals("bellSound")) {
                    return XTermBase.this.executeJs(false, "this[$0]=$1", new Serializable[]{name, arg});
                }
                return XTermBase.this.executeJs(false, "this.terminal.options[$0]=$1", new Serializable[]{name, arg});
            }
            if (args == null || args.length == 0) {
                return XTermBase.this.executeJs(hasResult, "return this.terminal[$0]()", new Serializable[]{name});
            }
            if (args.length == 1) {
                return XTermBase.this.executeJs(hasResult, "return this.terminal[$0]($1)", new Serializable[]{name, (Serializable)args[0]});
            }
            Serializable[] sargs = new Serializable[args.length];
            System.arraycopy(args, 0, sargs, 0, args.length);
            String expr = IntStream.rangeClosed(1, args.length).mapToObj(i -> "$" + i).collect(Collectors.joining(","));
            return XTermBase.this.executeJs(hasResult, "return this.terminal[$0](" + expr + ")", new Serializable[]{name, sargs});
        }
    }
}

