/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.xterm;

import com.flowingcode.vaadin.addons.xterm.ITerminalConsole;
import com.flowingcode.vaadin.addons.xterm.XTerm;
import com.flowingcode.vaadin.addons.xterm.XTermBase;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.shared.Registration;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class TerminalHistory
implements Serializable {
    private LinkedList<String> history = new LinkedList();
    private transient ListIterator<String> iterator;
    private final XTermBase terminal;
    private List<Registration> registrations;
    private String lastRet;
    private String initialLine;
    private Integer maxSize;

    protected <T extends XTermBase> TerminalHistory(T terminal) {
        if (TerminalHistory.of(terminal) != null) {
            throw new IllegalArgumentException("The terminal already has a history");
        }
        this.terminal = terminal;
        ComponentUtil.setData(terminal, TerminalHistory.class, (Object)this);
    }

    public static <T extends XTermBase> TerminalHistory of(T xterm) {
        return (TerminalHistory)ComponentUtil.getData(xterm, TerminalHistory.class);
    }

    public static <T extends XTermBase> void extend(XTerm xterm) {
        TerminalHistory history = new TerminalHistory(xterm);
        history.setEnabled(true);
    }

    public void setMaxSize(Integer maxSize) {
        if (maxSize != null && maxSize < 0) {
            throw new IllegalArgumentException();
        }
        this.maxSize = maxSize;
        this.iterator = null;
        if (maxSize != null) {
            while (this.history.size() > maxSize) {
                this.history.remove(0);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (!enabled && this.registrations != null) {
            this.registrations.forEach(Registration::remove);
            this.registrations = null;
        } else if (enabled && this.registrations == null) {
            this.registrations = new ArrayList<Registration>();
            this.registrations.add(((ITerminalConsole)((Object)this.terminal)).addLineListener((ComponentEventListener<ITerminalConsole.LineEvent>)(ComponentEventListener & Serializable)ev -> {
                this.add(ev.getLine());
                this.resetIterator();
            }));
            this.registrations.add(this.terminal.addCustomKeyListener((DomEventListener & Serializable)ev -> this.handleArrowUp(), Key.ARROW_UP, new KeyModifier[0]));
            this.registrations.add(this.terminal.addCustomKeyListener((DomEventListener & Serializable)ev -> this.handleArrowDown(), Key.ARROW_DOWN, new KeyModifier[0]));
        }
    }

    public boolean isEnabled() {
        return this.registrations != null;
    }

    private void handleArrowUp() {
        if (this.initialLine == null) {
            ((ITerminalConsole)((Object)this.terminal)).getCurrentLine().thenAccept(currentLine -> {
                this.initialLine = currentLine;
                this.write(this.previous());
            });
        } else {
            this.write(this.previous());
        }
    }

    private void handleArrowDown() {
        this.write(this.next());
    }

    private void write(String line) {
        if (line != null) {
            String prompt = ((ITerminalConsole)((Object)this.terminal)).getPrompt();
            this.terminal.write("\u001b[<2K\u001b[<H\u001b[G" + prompt + line);
            this.lastRet = line;
        }
    }

    private ListIterator<String> listIterator() {
        if (this.iterator == null) {
            this.iterator = this.history.listIterator(this.history.size());
        }
        return this.iterator;
    }

    private Iterator<String> forwardIterator() {
        return this.listIterator();
    }

    private Iterator<String> reverseIterator() {
        if (this.iterator == null) {
            this.iterator = this.history.listIterator(this.history.size());
        }
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return TerminalHistory.this.iterator.hasPrevious();
            }

            @Override
            public String next() {
                return TerminalHistory.this.iterator.previous();
            }
        };
    }

    public void add(String line) {
        if (!(line = line.trim()).isEmpty()) {
            this.history.add(Objects.requireNonNull(line));
            this.resetIterator();
            if (this.maxSize != null && this.history.size() > this.maxSize) {
                this.history.removeLast();
            }
        }
    }

    private void resetIterator() {
        this.lastRet = null;
        this.iterator = null;
    }

    private Optional<String> find(Iterator<String> iterator, Predicate<String> predicate) {
        while (iterator.hasNext()) {
            String line = iterator.next();
            if (!predicate.test(line) || line.equals(this.lastRet)) continue;
            return Optional.of(line);
        }
        return Optional.empty();
    }

    private String previous() {
        return this.find(this.reverseIterator(), line -> true).orElse(null);
    }

    private String next() {
        return this.find(this.forwardIterator(), line -> true).orElseGet(() -> {
            String result = this.initialLine;
            this.initialLine = null;
            return result;
        });
    }

    public void clear() {
        this.history.clear();
    }

    public List<String> getLines() {
        return Collections.unmodifiableList(this.history);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        int cursor = Optional.ofNullable(this.iterator).map(ListIterator::nextIndex).orElse(this.history.size());
        out.defaultWriteObject();
        out.writeInt(cursor);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        int cursor = in.readInt();
        if (cursor != this.history.size()) {
            this.iterator = this.history.listIterator(cursor);
        }
    }
}

