/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.xterm;

import com.flowingcode.vaadin.addons.xterm.ITerminal;
import com.flowingcode.vaadin.addons.xterm.ITerminalOptions;
import com.flowingcode.vaadin.addons.xterm.TerminalAddon;
import com.flowingcode.vaadin.addons.xterm.TerminalTheme;
import com.flowingcode.vaadin.addons.xterm.XTerm;
import com.flowingcode.vaadin.addons.xterm.utils.StateMemoizer;
import com.vaadin.flow.component.ComponentEventListener;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;

public class PreserveStateAddon
extends TerminalAddon
implements ITerminal,
ITerminalOptions {
    private final XTerm xterm;
    private final StringBuilder scrollbackBuffer = new StringBuilder();
    private boolean wasDetachedOnce = false;
    private final StateMemoizer optionsMemoizer;
    private final ITerminalOptions optionsDelegate;

    public PreserveStateAddon(XTerm xterm) {
        super(xterm);
        this.xterm = Objects.requireNonNull(xterm);
        this.optionsMemoizer = new StateMemoizer(xterm, ITerminalOptions.class);
        this.optionsDelegate = (ITerminalOptions)this.optionsMemoizer.getProxy();
        xterm.addAttachListener((ComponentEventListener & Serializable)e -> {
            if (this.wasDetachedOnce) {
                this.optionsMemoizer.apply();
                xterm.write(this.scrollbackBuffer.toString());
                xterm.writePrompt();
            }
        });
        xterm.addDetachListener((ComponentEventListener & Serializable)e -> {
            this.wasDetachedOnce = true;
        });
        xterm.addLineListener((ComponentEventListener & Serializable)e -> {
            this.scrollbackBuffer.append(xterm.getPrompt());
            this.scrollbackBuffer.append(e.getLine());
            this.scrollbackBuffer.append('\n');
        });
    }

    @Override
    public void blur() {
        this.xterm.blur();
    }

    @Override
    public void focus() {
        this.xterm.focus();
    }

    @Override
    public CompletableFuture<Boolean> hasSelection() {
        return this.xterm.hasSelection();
    }

    @Override
    public CompletableFuture<String> getSelection() {
        return this.xterm.getSelection();
    }

    @Override
    public void clearSelection() {
        this.xterm.clearSelection();
    }

    @Override
    public void select(int column, int row, int length) {
        this.xterm.select(column, row, length);
    }

    @Override
    public void selectAll() {
        this.xterm.selectAll();
    }

    @Override
    public void selectLines(int start, int end) {
        this.xterm.selectLines(start, end);
    }

    @Override
    public void scrollLines(int amount) {
        this.xterm.scrollLines(amount);
    }

    @Override
    public void scrollPages(int pageCount) {
        this.xterm.scrollPages(pageCount);
    }

    @Override
    public void scrollToTop() {
        this.xterm.scrollToTop();
    }

    @Override
    public void scrollToBottom() {
        this.xterm.scrollToBottom();
    }

    @Override
    public void scrollToLine(int line) {
        this.xterm.scrollToLine(line);
    }

    @Override
    public void clear() {
        this.xterm.clear();
        this.scrollbackBuffer.delete(0, this.scrollbackBuffer.length());
    }

    @Override
    public void write(String data) {
        this.xterm.write(data);
        this.scrollbackBuffer.append(data);
    }

    @Override
    public void writeln(String data) {
        this.xterm.writeln(data);
        this.scrollbackBuffer.append(data);
        this.scrollbackBuffer.append('\n');
    }

    @Override
    public void paste(String data) {
        this.xterm.paste(data);
    }

    @Override
    public void refresh(int start, int end) {
        this.xterm.refresh(start, end);
    }

    @Override
    public void reset() {
        this.xterm.reset();
        this.scrollbackBuffer.delete(0, this.scrollbackBuffer.length());
    }

    @Override
    public void resize(int columns, int rows) {
        this.xterm.resize(columns, rows);
    }

    public void setPrompt(String prompt) {
        this.xterm.setPrompt(prompt);
    }

    public String getPrompt() {
        return this.xterm.getPrompt();
    }

    public void writePrompt() {
        this.xterm.writePrompt();
    }

    public String getScrollbackBuffer() {
        return this.scrollbackBuffer.toString();
    }

    public XTerm getXTerm() {
        return this.xterm;
    }

    @Override
    @Generated
    public void setBellSound(String value) {
        this.optionsDelegate.setBellSound(value);
    }

    @Override
    @Generated
    public void setBellStyle(ITerminalOptions.BellStyle value) {
        this.optionsDelegate.setBellStyle(value);
    }

    @Override
    @Generated
    public void setCursorBlink(boolean value) {
        this.optionsDelegate.setCursorBlink(value);
    }

    @Override
    @Generated
    public void setCursorStyle(ITerminalOptions.CursorStyle value) {
        this.optionsDelegate.setCursorStyle(value);
    }

    @Override
    @Generated
    public void setCursorWidth(int value) {
        this.optionsDelegate.setCursorWidth(value);
    }

    @Override
    @Generated
    public void setDrawBoldTextInBrightColors(boolean value) {
        this.optionsDelegate.setDrawBoldTextInBrightColors(value);
    }

    @Override
    @Generated
    public void setFastScrollModifier(ITerminalOptions.FastScrollModifier value) {
        this.optionsDelegate.setFastScrollModifier(value);
    }

    @Override
    @Generated
    public void setFastScrollSensitivity(int number) {
        this.optionsDelegate.setFastScrollSensitivity(number);
    }

    @Override
    @Generated
    public void setFontSize(int number) {
        this.optionsDelegate.setFontSize(number);
    }

    @Override
    @Generated
    public void setFontFamily(String fontFamily) {
        this.optionsDelegate.setFontFamily(fontFamily);
    }

    @Override
    @Generated
    public void setFontWeight(int value) {
        this.optionsDelegate.setFontWeight(value);
    }

    @Override
    @Generated
    public void setFontWeightBold(int value) {
        this.optionsDelegate.setFontWeightBold(value);
    }

    @Override
    @Generated
    public void setLetterSpacing(int value) {
        this.optionsDelegate.setLetterSpacing(value);
    }

    @Override
    @Generated
    public void setLineHeight(int value) {
        this.optionsDelegate.setLineHeight(value);
    }

    @Override
    @Generated
    public void setMacOptionIsMeta(boolean value) {
        this.optionsDelegate.setMacOptionIsMeta(value);
    }

    @Override
    @Generated
    public void setMacOptionClickForcesSelection(boolean value) {
        this.optionsDelegate.setMacOptionClickForcesSelection(value);
    }

    @Override
    @Generated
    public void setMinimumContrastRatio(int value) {
        this.optionsDelegate.setMinimumContrastRatio(value);
    }

    @Override
    @Generated
    public void setTheme(TerminalTheme theme) {
        this.optionsDelegate.setTheme(theme);
    }

    @Override
    @Generated
    public void setRendererType(ITerminalOptions.RendererType value) {
        this.optionsDelegate.setRendererType(value);
    }

    @Override
    @Generated
    public void setRightClickSelectsWord(boolean value) {
        this.optionsDelegate.setRightClickSelectsWord(value);
    }

    @Override
    @Generated
    public void setScreenReaderMode(boolean value) {
        this.optionsDelegate.setScreenReaderMode(value);
    }

    @Override
    @Generated
    public void setScrollback(int value) {
        this.optionsDelegate.setScrollback(value);
    }

    @Override
    @Generated
    public void setScrollSensitivity(int value) {
        this.optionsDelegate.setScrollSensitivity(value);
    }

    @Override
    @Generated
    public void setTabStopWidth(int value) {
        this.optionsDelegate.setTabStopWidth(value);
    }

    @Override
    @Generated
    public void setWordSeparator(String value) {
        this.optionsDelegate.setWordSeparator(value);
    }
}

