/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.xterm.utils;

import com.flowingcode.vaadin.addons.xterm.utils.StateMemoizer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class StateMemoizerTest {
    private StateMemoizer memoizer;
    private BunchOfSetters proxy;
    private MyBean bean;

    @Before
    public void setupTestValues() {
        this.bean = new MyBean();
        this.memoizer = new StateMemoizer((Object)this.bean, new Class[]{BunchOfSetters.class});
        this.proxy = (BunchOfSetters)this.memoizer.getProxy();
    }

    @Test
    public void emptyMemoizerApplySucceedsButDoesNothing() {
        this.memoizer.apply();
        Assert.assertNull((Object)this.bean.getFoo());
        Assert.assertEquals((long)0L, (long)this.bean.getBar());
    }

    @Test
    public void proxyModificationPassesValuesThrough() {
        this.proxy.setFoo("foo");
        Assert.assertEquals((Object)"foo", (Object)this.bean.getFoo());
        this.proxy.setBar(25);
        Assert.assertEquals((long)25L, (long)this.bean.getBar());
    }

    @Test
    public void applyAppliesInvokedSettersOnly() {
        this.proxy.setFoo("foo");
        this.bean.setFoo("bar");
        this.bean.setBar(25);
        this.memoizer.apply();
        Assert.assertEquals((Object)"foo", (Object)this.bean.getFoo());
        Assert.assertEquals((long)25L, (long)this.bean.getBar());
    }

    @Test
    public void applyBasicTest() {
        this.proxy.setFoo("foo");
        this.proxy.setBar(25);
        this.bean.setFoo("FOO");
        this.bean.setBar(26);
        this.memoizer.apply();
        Assert.assertEquals((Object)"foo", (Object)this.bean.getFoo());
        Assert.assertEquals((long)25L, (long)this.bean.getBar());
    }

    @Test
    public void consequentSetterCallsAppliedProperly() {
        this.proxy.setFoo("foo");
        Assert.assertEquals((Object)"foo", (Object)this.bean.getFoo());
        this.proxy.setFoo("bar");
        Assert.assertEquals((Object)"bar", (Object)this.bean.getFoo());
        this.proxy.setBar(25);
        this.bean.setFoo("FOO");
        this.bean.setBar(26);
        this.memoizer.apply();
        Assert.assertEquals((Object)"bar", (Object)this.bean.getFoo());
        Assert.assertEquals((long)25L, (long)this.bean.getBar());
    }

    public static class MyBean
    implements BunchOfSetters {
        private String foo;
        private int bar;

        public String getFoo() {
            return this.foo;
        }

        @Override
        public void setFoo(String foo) {
            this.foo = foo;
        }

        public int getBar() {
            return this.bar;
        }

        @Override
        public void setBar(int bar) {
            this.bar = bar;
        }
    }

    public static interface BunchOfSetters {
        public void setFoo(String var1);

        public void setBar(int var1);
    }
}

