/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.xterm;

import com.flowingcode.vaadin.addons.DemoLayout;
import com.flowingcode.vaadin.addons.GithubLink;
import com.flowingcode.vaadin.addons.xterm.ITerminalClipboard;
import com.flowingcode.vaadin.addons.xterm.ITerminalOptions;
import com.flowingcode.vaadin.addons.xterm.TerminalHistory;
import com.flowingcode.vaadin.addons.xterm.TerminalTheme;
import com.flowingcode.vaadin.addons.xterm.XTerm;
import com.flowingcode.vaadin.addons.xterm.XTermBase;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;

@Route(value="xterm", layout=DemoLayout.class)
@GithubLink(value="https://github.com/FlowingCode/XTermConsoleAddon")
public class XtermDemoView
extends VerticalLayout {
    private XTerm xterm;

    public XtermDemoView() {
        this.setSizeFull();
        this.setPadding(false);
        this.getElement().getStyle().set("background", "black");
        this.xterm = new XTerm();
        this.xterm.setPrompt("[user@xterm ~]$ ");
        this.xterm.writeln("xterm add-on by Flowing Code S.A.\n\n");
        this.xterm.writeln("Commands: time, date, beep, color, history, prompt\n");
        this.xterm.writePrompt();
        this.xterm.setCursorBlink(true);
        this.xterm.setCursorStyle(ITerminalOptions.CursorStyle.UNDERLINE);
        this.xterm.setBellStyle(ITerminalOptions.BellStyle.SOUND);
        this.xterm.setSizeFull();
        this.xterm.setCopySelection(true);
        this.xterm.setUseSystemClipboard(ITerminalClipboard.UseSystemClipboard.READWRITE);
        this.xterm.setPasteWithMiddleClick(true);
        this.xterm.setPasteWithRightClick(true);
        TerminalHistory.extend((XTerm)this.xterm);
        this.xterm.addLineListener((ComponentEventListener & Serializable)ev -> {
            String[] line = ev.getLine().toLowerCase().split("\\s+", 2);
            switch (line[0]) {
                case "time": {
                    this.xterm.writeln(LocalTime.now().truncatedTo(ChronoUnit.SECONDS).format(DateTimeFormatter.ISO_TIME));
                    break;
                }
                case "date": {
                    this.xterm.writeln(LocalDate.now().toString());
                    break;
                }
                case "beep": {
                    this.xterm.write("\u0007");
                    break;
                }
                case "color": {
                    if (line.length > 1) {
                        if (line[1].equals("on")) {
                            this.xterm.setTheme(new TerminalTheme().withBackground("rgb(103,195,228)").withForeground("rgb(0,0,0)"));
                            break;
                        }
                        if (line[1].equals("off")) {
                            this.xterm.setTheme(new TerminalTheme());
                            break;
                        }
                    }
                    this.xterm.writeln("color on:  use TI-99/4A palette");
                    this.xterm.writeln("color off: use default palette");
                    break;
                }
                case "history": {
                    this.showHistory();
                    break;
                }
                case "prompt": {
                    if (line.length == 1) {
                        this.xterm.writeln("Write prompt off for disabling the prompt");
                        this.xterm.writeln("Write prompt <text> for setting the prompt");
                        break;
                    }
                    if (line[1].equals("off")) {
                        this.xterm.setPrompt(null);
                        break;
                    }
                    this.xterm.setPrompt(line[1].trim() + " ");
                    break;
                }
                default: {
                    if (ev.getLine().trim().isEmpty()) break;
                    this.xterm.writeln("Unknown command: " + line[0]);
                }
            }
            this.xterm.writePrompt();
        });
        this.xterm.focus();
        this.xterm.fit();
        this.add(new Component[]{this.xterm});
    }

    private void showHistory() {
        int index = 1;
        StringBuilder sb = new StringBuilder();
        for (String line : TerminalHistory.of((XTermBase)this.xterm).getLines()) {
            sb.append(String.format("%5s  %s\n", index++, line));
        }
        this.xterm.write(sb.toString());
    }
}

