/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.xterm;

import com.flowingcode.vaadin.addons.xterm.ITerminalConsole;
import com.flowingcode.vaadin.addons.xterm.PreserveStateAddon;
import com.flowingcode.vaadin.addons.xterm.XTerm;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentUtil;
import org.junit.Assert;
import org.junit.Test;

public class PreserveStateAddonTest {
    @Test
    public void smoke() {
        new PreserveStateAddon(new XTerm());
    }

    @Test
    public void writeGoesToScrollbackBuffer() {
        PreserveStateAddon addon = new PreserveStateAddon(new XTerm());
        addon.write("foo");
        addon.writeln("bar");
        addon.write("baz");
        Assert.assertEquals((Object)"foobar\nbaz", (Object)addon.getScrollbackBuffer());
    }

    @Test
    public void promptGoesToScrollbackBufferAfterSubmit() {
        XTerm xterm = new XTerm();
        PreserveStateAddon addon = new PreserveStateAddon(xterm);
        Component component = (Component)xterm.getElement().getComponent().get();
        addon.setPrompt("a> ");
        addon.writePrompt();
        ComponentUtil.fireEvent((Component)component, (ComponentEvent)new ITerminalConsole.LineEvent(xterm, true, "bar"));
        addon.setPrompt("b> ");
        addon.writePrompt();
        ComponentUtil.fireEvent((Component)component, (ComponentEvent)new ITerminalConsole.LineEvent(xterm, true, "baz"));
        addon.setPrompt("c> ");
        addon.writePrompt();
        Assert.assertEquals((Object)"a> bar\nb> baz\n", (Object)addon.getScrollbackBuffer());
    }

    @Test
    public void clearClearsScrollbackBuffer() {
        PreserveStateAddon addon = new PreserveStateAddon(new XTerm());
        addon.writeln("bar");
        addon.clear();
        Assert.assertEquals((Object)"", (Object)addon.getScrollbackBuffer());
    }

    @Test
    public void resetClearsScrollbackBuffer() {
        PreserveStateAddon addon = new PreserveStateAddon(new XTerm());
        addon.writeln("bar");
        addon.reset();
        Assert.assertEquals((Object)"", (Object)addon.getScrollbackBuffer());
    }
}

