/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.verticalmenu;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JavaScript;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.H1;
import com.vaadin.flow.component.html.Section;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Tag(value="div")
@StyleSheet(value="context://frontend/styles/vertical-menu-styles.css")
@JavaScript(value="./scripts/vertical-menu-styles.js")
public class VerticalMenu
extends Component
implements HasSize {
    private boolean menuOpened;
    private List<Section> sections = new ArrayList<Section>();

    public VerticalMenu(Section ... sections) {
        this.setSizeFull();
        this.getElement().setAttribute("class", "wrapper");
        this.getElement().appendChild(new Element[]{new H1("Menu").getElement()});
        Icon button = VaadinIcon.MENU.create();
        button.addClassName("menu-btn");
        button.getElement().setAttribute("onclick", "toggleMenu()");
        button.getElement().addEventListener("click", (DomEventListener & Serializable)ev -> {
            this.menuOpened = true;
        });
        this.getElement().appendChild(new Element[]{button.getElement()});
        this.getSections().addAll(Arrays.asList(sections));
        this.reloadSections();
        UI.getCurrent().getPage().executeJs("goToPage(0)", new Serializable[0]);
    }

    public void reloadSections() {
        int index = 1;
        for (Section section : this.getSections()) {
            this.addMenu(section, index++);
        }
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.getUI().ifPresent(ui -> ui.getElement().getClassList().add((Object)"vertical-menu"));
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.getUI().ifPresent(ui -> ui.getElement().getClassList().remove((Object)"vertical-menu"));
        super.onDetach(detachEvent);
    }

    private void addMenu(Section s, int index) {
        s.getElement().setAttribute("onclick", "goToPage(" + (index - 1) + ")");
        s.addClassName("class" + index);
        s.addClickListener((ComponentEventListener & Serializable)ev -> {
            if (this.menuOpened) {
                this.fireEvent(new MenuSelectedEvent((Section)ev.getSource(), true));
                this.menuOpened = false;
            }
        });
        this.getElement().appendChild(new Element[]{s.getElement()});
    }

    public Registration addMenuSelectedListener(ComponentEventListener<MenuSelectedEvent> listener) {
        return this.addListener(MenuSelectedEvent.class, listener);
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public void setSections(List<Section> sections) {
        this.sections = sections;
        this.reloadSections();
    }

    public static class MenuSelectedEvent
    extends ComponentEvent<Section> {
        public MenuSelectedEvent(Section source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

