/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.simpletimer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Synchronize;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

@Tag(value="simple-timer")
@JsModule(value="./simple-timer/simple-timer.js")
public class SimpleTimer
extends Component
implements HasSize,
HasStyle,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String DISPLAY = "display";
    private static final String INLINE = "inline";
    private static final String CURRENT_TIME = "currentTime";

    public SimpleTimer() {
        this.getElement().getStyle().set(DISPLAY, INLINE);
    }

    public void setStartTime(Number startTime) {
        this.getElement().setProperty("countUp", false);
        this.getElement().setProperty("startTime", startTime.doubleValue());
        this.getElement().setProperty(CURRENT_TIME, startTime.doubleValue());
        this.reset();
    }

    public void setEndTime(Number endTime) {
        this.getElement().setProperty("countUp", true);
        this.getElement().setProperty("endTime", endTime.doubleValue());
        this.reset();
    }

    public void setFractions(boolean fractions) {
        this.getElement().setProperty("fractions", fractions);
    }

    public void setMinutes(boolean minutes) {
        this.getElement().setProperty("minutes", minutes);
    }

    public void setHours(boolean hours) {
        this.getElement().setProperty("hours", hours);
    }

    public void setDoubleDigitHours(boolean doubleDigitHours) {
        this.getElement().setProperty("doubleDigitHours", doubleDigitHours);
    }

    public void start() {
        this.getElement().callJsFunction("start", new Serializable[0]);
    }

    public void pause() {
        this.getElement().callJsFunction("pause", new Serializable[0]);
    }

    public void reset() {
        this.getElement().callJsFunction("ready", new Serializable[0]);
    }

    @Synchronize(property="isRunning", value={"is-running-changed"})
    public boolean isRunning() {
        return this.getElement().getProperty("isRunning", false);
    }

    @Synchronize(value={"is-running-changed"})
    public BigDecimal getCurrentTime() {
        return BigDecimal.valueOf(this.getElement().getProperty(CURRENT_TIME, 0.0));
    }

    public CompletableFuture<BigDecimal> getCurrentTimeAsync() {
        return this.getElement().executeJs("return this.currentTime", new Serializable[0]).toCompletableFuture(Double.class).thenApply(BigDecimal::valueOf);
    }

    public Registration addCurrentTimeChangeListener(PropertyChangeListener listener, long period, TimeUnit periodUnit) {
        int millis = (int)Math.min(periodUnit.toMillis(period), Integer.MAX_VALUE);
        if (listener == null) {
            listener = (PropertyChangeListener & Serializable)ev -> {};
        }
        return this.getElement().addPropertyChangeListener(CURRENT_TIME, "current-time-changed", (PropertyChangeListener)listener).throttle(millis);
    }

    public Registration addTimerEndEvent(ComponentEventListener<TimerEndedEvent> listener) {
        return this.addListener(TimerEndedEvent.class, listener);
    }

    public boolean isVisible() {
        return this.getStyle().get(DISPLAY).equals(INLINE);
    }

    public void setVisible(boolean visible) {
        this.getStyle().set(DISPLAY, visible ? INLINE : "none");
    }

    @DomEvent(value="simple-timer-end")
    public static class TimerEndedEvent
    extends ComponentEvent<SimpleTimer> {
        public TimerEndedEvent(SimpleTimer source, boolean fromClient) {
            super((Component)source, fromClient);
        }
    }
}

