/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.simpletimer;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.simpletimer.SimpleTimer;
import com.flowingcode.vaadin.addons.simpletimer.SimpletimerDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import java.math.BigDecimal;

@PageTitle(value="Simple Timer Demo")
@DemoSource
@Route(value="simple-timer/simple-timer", layout=SimpletimerDemoView.class)
public class SimpletimerDemo
extends Div {
    private final SimpleTimer timer = new SimpleTimer();
    private boolean countUpMode;
    private BigDecimal time = new BigDecimal(60);

    public SimpletimerDemo() {
        this.setSizeFull();
        this.timer.setWidth("100px");
        this.timer.setHeight("50px");
        this.timer.getStyle().set("font-size", "40px");
        this.timer.setStartTime((Number)60);
        Span timerTitle = new Span("Simple Count Up Timer");
        TextField startTime = new TextField("Start Time", (HasValue.ValueChangeListener & Serializable)e -> {
            try {
                this.time = new BigDecimal((String)e.getValue());
                this.update();
            }
            catch (Exception ex) {
                Notification.show((String)"Please enter a number");
            }
        });
        Checkbox countUp = new Checkbox("Count Up", false);
        countUp.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            this.countUpMode = (Boolean)countUp.getValue();
            if (this.countUpMode) {
                startTime.setLabel("End Time");
                timerTitle.setText("Simple Count Up Timer");
            } else {
                startTime.setLabel("Start Time");
                timerTitle.setText("Simple Countdown Timer");
            }
            this.update();
        });
        Button start = new Button("Start/Stop", (ComponentEventListener & Serializable)e -> this.timer.start());
        Button stop = new Button("Stop", (ComponentEventListener & Serializable)e -> this.timer.pause());
        Button reset = new Button("Reset", (ComponentEventListener & Serializable)e -> this.timer.reset());
        Button running = new Button("Current Time", (ComponentEventListener & Serializable)e -> this.timer.getCurrentTimeAsync().thenAccept(time -> Notification.show((String)(time.toPlainString() + (this.timer.isRunning() ? "" : " (Not Running)")))));
        Checkbox fractions = new Checkbox("Fractions", true);
        fractions.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.timer.setFractions(((Boolean)e.getValue()).booleanValue()));
        Checkbox minutes = new Checkbox("Minutes", (HasValue.ValueChangeListener & Serializable)e -> this.timer.setMinutes(((Boolean)e.getValue()).booleanValue()));
        Checkbox hours = new Checkbox("Hours", (HasValue.ValueChangeListener & Serializable)e -> this.timer.setHours(((Boolean)e.getValue()).booleanValue()));
        Checkbox doubleDigitHours = new Checkbox("Double digit hours", (HasValue.ValueChangeListener & Serializable)e -> this.timer.setDoubleDigitHours(((Boolean)e.getValue()).booleanValue()));
        Checkbox visible = new Checkbox("Visible", (HasValue.ValueChangeListener & Serializable)e -> {
            if (e.isFromClient()) {
                this.timer.setVisible(!this.timer.isVisible());
            }
        });
        visible.setValue((Object)true);
        this.timer.addTimerEndEvent((ComponentEventListener & Serializable)e -> Notification.show((String)"Timer Ended"));
        HorizontalLayout topLayout = new HorizontalLayout(new Component[]{timerTitle, this.timer});
        topLayout.setAlignItems(FlexComponent.Alignment.CENTER);
        HorizontalLayout options = new HorizontalLayout(new Component[]{countUp, fractions, minutes, hours, visible, doubleDigitHours});
        options.setAlignItems(FlexComponent.Alignment.CENTER);
        options.getStyle().set("flex-wrap", "wrap");
        HorizontalLayout bottomLayout = new HorizontalLayout(new Component[]{start, stop, reset, running});
        bottomLayout.setAlignItems(FlexComponent.Alignment.BASELINE);
        this.add(new Component[]{new VerticalLayout(new Component[]{topLayout, startTime, options, bottomLayout})});
    }

    private void update() {
        if (this.countUpMode) {
            this.timer.setEndTime((Number)this.time);
        } else {
            this.timer.setStartTime((Number)this.time);
        }
    }
}

