/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.rssitems;

import com.flowingcode.vaadin.addons.rssitems.RssItemsModel;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.polymertemplate.PolymerTemplate;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

@Tag(value="rss-items")
@NpmPackage.Container(value={@NpmPackage(value="@polymer/iron-ajax", version="3.0.1"), @NpmPackage(value="@polymer/iron-image", version="3.0.2"), @NpmPackage(value="x2js", version="3.4.0")})
@JsModule(value="./rss-items.js")
public class RssItems
extends PolymerTemplate<RssItemsModel>
implements HasSize,
HasStyle {
    private String url;
    private boolean extractImageFromDescription;
    private static final String ERROR_RSS = "<rss>\r\n  <channel>\r\n    <item>\r\n      <title>Error Retrieving RSS</title>\r\n      <link>https://</link>\r\n      <description>There was an error retrieving the rss: %s</description>\r\n      <thumbnail url=\"https://\"></thumbnail>\r\n    </item>";
    private static final String IMAGE_METHOD = "    $0._getItemImageScr = function (item) {\r\n        var element = document.createElement('div');\r\n        element.innerHTML = item.%%ATTRIBUTE_NAME%%;\r\n        var image = element.querySelector('img') || {};\r\n        return image.src || '';\r\n    }\r\n";
    private static final int DEFAULT_MAX = Integer.MAX_VALUE;
    private static final int DEFAULT_MAX_TITLE_LENGTH = 50;
    private static final int DEFAULT_MAX_EXCERPT_LENGTH = 100;

    public RssItems(String url, int max, int maxTitleLength, int maxExcerptLength, boolean extractImageFromDescription) {
        this(url, max, maxTitleLength, maxExcerptLength, extractImageFromDescription, "description");
    }

    public RssItems(String url, int max, int maxTitleLength, int maxExcerptLength, boolean extractImageFromDescription, String attributeName) {
        this.extractImageFromDescription = extractImageFromDescription;
        if (this.extractImageFromDescription) {
            UI.getCurrent().getPage().executeJs(IMAGE_METHOD.replaceAll("%%ATTRIBUTE_NAME%%", attributeName), new Serializable[]{this.getElement()});
        }
        ((RssItemsModel)this.getModel()).setAuto(true);
        ((RssItemsModel)this.getModel()).setMax(max);
        ((RssItemsModel)this.getModel()).setMaxExcerptLength(maxExcerptLength);
        ((RssItemsModel)this.getModel()).setMaxTitleLength(maxTitleLength);
        this.addClassName("x-scope");
        this.addClassName("rss-items-0");
        this.url = url;
        this.refreshUrl();
    }

    public RssItems(String url) {
        this(url, Integer.MAX_VALUE, 50, 100, false);
    }

    private void refreshUrl() {
        try {
            String rss = this.obtainRss(this.url);
            this.invokeXmlToItems(rss);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.invokeXmlToItems(String.format(ERROR_RSS, e.toString()));
        }
    }

    private void invokeXmlToItems(String rss) {
        this.getElement().executeJs("this.xmlToItems($0)", new Serializable[]{rss});
    }

    private String obtainRss(String url) throws ClientProtocolException, IOException {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        HttpGet request = new HttpGet(URI.create(url));
        request.addHeader("Content-Type", "application/xml");
        HttpResponse response = client.execute((HttpUriRequest)request);
        if (response.getStatusLine().getStatusCode() > 200) {
            throw new RuntimeException("Problem reading the rss url: " + response.getStatusLine().getReasonPhrase());
        }
        HttpEntity entity = response.getEntity();
        String result = EntityUtils.toString((HttpEntity)entity);
        EntityUtils.consume((HttpEntity)entity);
        request.completed();
        return result;
    }

    public void setMaxTitleLength(int length) {
        ((RssItemsModel)this.getModel()).setMaxTitleLength(length);
        this.refreshUrl();
    }

    public void setMaxExcerptLength(int length) {
        ((RssItemsModel)this.getModel()).setMaxExcerptLength(length);
        this.refreshUrl();
    }

    public void setMax(int max) {
        ((RssItemsModel)this.getModel()).setMax(max);
        this.refreshUrl();
    }

    public void setExtractImageFromDescription(boolean extractImageFromDescription) {
        this.extractImageFromDescription = extractImageFromDescription;
        this.refreshUrl();
    }
}

