/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.granitealert;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.granitealert.GraniteAlert;
import com.flowingcode.vaadin.addons.granitealert.GranitealertDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;

@PageTitle(value="Granite Alert Demo")
@DemoSource
@Route(value="granite-alert/granite-alert", layout=GranitealertDemoView.class)
@StyleSheet(value="context://frontend/styles/granitealert/demo-styles.css")
@CssImport(value="./styles/granitealert/custom-granite-styles.css", themeFor="granite-alert-mixin")
public class GranitealertDemo
extends Div {
    private Div container = new Div();

    public GranitealertDemo() {
        this.createAlert(null, "boring", "Welcome to the GraniteAlertAddon demo. Please click any button below.");
        HorizontalLayout buttons = new HorizontalLayout();
        buttons.setSpacing(true);
        buttons.add(new Component[]{new Button((Component)VaadinIcon.EXCLAMATION.create(), (ComponentEventListener & Serializable)ev -> this.createErrorAlert())});
        buttons.add(new Component[]{new Button((Component)VaadinIcon.WARNING.create(), (ComponentEventListener & Serializable)ev -> this.createWarningAlert())});
        buttons.add(new Component[]{new Button((Component)VaadinIcon.INFO.create(), (ComponentEventListener & Serializable)ev -> this.createInfoAlert())});
        buttons.add(new Component[]{new Button((Component)VaadinIcon.CHECK.create(), (ComponentEventListener & Serializable)ev -> this.createSuccessAlert())});
        buttons.add(new Component[]{new Button((Component)VaadinIcon.MEH_O.create(), (ComponentEventListener & Serializable)ev -> this.createCustomAlert("boring"))});
        buttons.add(new Component[]{new Button((Component)VaadinIcon.SMILEY_O.create(), (ComponentEventListener & Serializable)ev -> this.createCustomAlert("funny"))});
        this.setSizeFull();
        this.add(new Component[]{this.container, buttons});
    }

    private void createSuccessAlert() {
        this.createAlert(GraniteAlert.GraniteAlertLevel.SUCCESS, null, "Success");
    }

    private void createCustomAlert(String className) {
        this.createAlert(null, className, "Info");
    }

    private void createInfoAlert() {
        this.createAlert(GraniteAlert.GraniteAlertLevel.INFO, null, "Info");
    }

    private void createWarningAlert() {
        this.createAlert(GraniteAlert.GraniteAlertLevel.WARNING, null, "Warning");
    }

    private void createErrorAlert() {
        this.createAlert(GraniteAlert.GraniteAlertLevel.ERROR, null, "Error");
    }

    private void createAlert(GraniteAlert.GraniteAlertLevel level, String className, String message) {
        GraniteAlert alert = new GraniteAlert();
        alert.setCompact(true);
        if (level != null) {
            alert.setLevel(level);
        }
        if (className != null) {
            alert.addClassName(className);
        }
        alert.add(new Component[]{new Span(message)});
        Button button = new Button((Component)VaadinIcon.CLOSE_CIRCLE.create());
        button.addClickListener((ComponentEventListener & Serializable)ev -> this.container.remove(new Component[]{alert}));
        alert.add(new Component[]{button});
        this.container.add(new Component[]{alert});
    }
}

