/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.granitealert;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import java.util.Optional;

@Tag(value="granite-alert-mixin")
@JsModule.Container(value={@JsModule(value="./granite-alert/granite-alert.js"), @JsModule(value="./granite-alert-mixin/granite-alert-mixin.js")})
public class GraniteAlert
extends Component
implements HasComponents,
HasStyle {
    private static final long serialVersionUID = 1L;

    public void setLevel(GraniteAlertLevel level) {
        this.getElement().setAttribute("level", level != null ? level.style : null);
    }

    public GraniteAlertLevel getLevel() {
        return Optional.ofNullable(this.getElement().getProperty("level")).map(x$0 -> GraniteAlertLevel.fromProperty(x$0)).orElse(GraniteAlertLevel.INFO);
    }

    public void setCompact(boolean value) {
        this.getElement().setAttribute("compact", value);
    }

    public static enum GraniteAlertLevel {
        ERROR("danger"),
        WARNING("warning"),
        INFO("info"),
        SUCCESS("success");

        private final String style;

        private GraniteAlertLevel(String style) {
            this.style = style;
        }

        private static GraniteAlertLevel fromProperty(String property) {
            for (GraniteAlertLevel level : GraniteAlertLevel.values()) {
                if (!level.style.equals(property)) continue;
                return level;
            }
            return null;
        }
    }
}

