/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.fontawesome;

import com.flowingcode.vaadin.addons.fontawesome.DemoViewSingle;
import com.flowingcode.vaadin.addons.fontawesome.FontAwesome;
import com.flowingcode.vaadin.addons.fontawesome.FontAwesomeReflect;
import com.flowingcode.vaadin.addons.fontawesome.FontawesomeDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextField;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

@PageTitle(value="Icons Gallery")
@Route(value="font-awesome-iron-iconset/icons", layout=FontawesomeDemoView.class)
@JsModule(value="./fc-font-awesome-gallery.ts")
@Uses.Container(value={@Uses(value=FontAwesome.Solid.Icon.class), @Uses(value=FontAwesome.Regular.Icon.class), @Uses(value=FontAwesome.Brands.Icon.class)})
public class IconsGalleryView
extends Div {
    public IconsGalleryView() {
        TextField filter = new TextField();
        filter.setValueChangeMode(ValueChangeMode.EAGER);
        filter.setWidth("calc(100vw - 56px)");
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)ev -> this.applyFilter(filter.getValue()));
        filter.setPlaceholder("Search icons");
        this.add(new Component[]{filter});
        this.setSizeUndefined();
        this.addClassName("main-icon-view");
        FontAwesomeReflect.getIconTypes().forEach(type -> this.add(new Component[]{new IconsGallery((Class<?>)type, (SerializableConsumer<String>)((SerializableConsumer & Serializable)this::showDetails))}));
        Div noResults = new Div(new Component[]{new Span("Your search did not match any icons.")});
        noResults.addClassName("no-results");
        noResults.getElement().setAttribute("hidden", "true");
        this.add(new Component[]{noResults});
    }

    private void showDetails(String icon) {
        DemoViewSingle view = new DemoViewSingle();
        Button closeButton = new Button((Component)FontAwesome.Solid.XMARK.create());
        closeButton.addClassName("close-button");
        HorizontalLayout top = new HorizontalLayout(new Component[]{closeButton});
        view.setParameter(null, icon.replace(':', '/'));
        Div div = new Div(new Component[]{top, view});
        div.addClassName("details-dialog");
        Dialog dlg = new Dialog(new Component[]{div});
        dlg.open();
        dlg.setWidth("600px");
        closeButton.addClickListener((ComponentEventListener & Serializable)ev -> dlg.close());
    }

    private void applyFilter(String filterString) {
        this.getChildren().filter(IconsGallery.class::isInstance).map(IconsGallery.class::cast).forEach(gallery -> gallery.filter(filterString));
    }

    @Tag(value="fc-font-awesome-gallery-demo")
    public static class IconsGallery
    extends Component {
        private static final String EVENT_DETAIL = "event.detail";

        public IconsGallery(Class<?> type, SerializableConsumer<String> iconClickListener) {
            String caption = "FontAwesome " + type.getSimpleName();
            String family = FontAwesomeReflect.getIconset(type);
            this.getElement().setProperty("caption", caption);
            this.getElement().setProperty("family", family);
            this.getElement().addEventListener("iconClick", (DomEventListener & Serializable)ev -> iconClickListener.accept((Object)ev.getEventData().getString(EVENT_DETAIL))).addEventData(EVENT_DETAIL);
        }

        public void filter(String filterString) {
            filterString = StringUtils.lowerCase((String)filterString);
            filterString = StringUtils.trimToNull((String)filterString);
            this.getElement().setProperty("filterString", filterString);
        }
    }
}

