/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.fontawesome;

import com.flowingcode.vaadin.addons.demo.DemoSource;
import com.flowingcode.vaadin.addons.fontawesome.FontAwesome;
import com.flowingcode.vaadin.addons.fontawesome.FontawesomeDemoView;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.renderer.LitRenderer;
import com.vaadin.flow.data.renderer.Renderer;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import java.util.List;

@DemoSource
@PageTitle(value="Lit Renderer")
@Route(value="font-awesome-iron-iconset/renderer", layout=FontawesomeDemoView.class)
@Uses.Container(value={@Uses(value=FontAwesome.Solid.Icon.class), @Uses(value=FontAwesome.Regular.Icon.class), @Uses(value=FontAwesome.Brands.Icon.class)})
public class LitRendererDemo
extends VerticalLayout {
    public LitRendererDemo() {
        Grid grid = new Grid();
        grid.setItems(List.of(new Person(100, "Lucas Kane", 68), new Person(101, "Peter Buchanan", 38), new Person(102, "Samuel Lee", 53), new Person(103, "Anton Ross", 37), new Person(104, "Aaron Atkinson", 18), new Person(105, "Jack Woodward", 28)));
        grid.addColumn((Renderer)LitRenderer.of((String)("<vaadin-icon icon='" + FontAwesome.Solid.CIRCLE_CHECK.getIconName() + "'></vaadin-icon>${item.id}")).withProperty("id", Person::getId)).setHeader("ID");
        grid.addColumn((Renderer)LitRenderer.of((String)("<vaadin-icon icon='" + FontAwesome.Regular.KEYBOARD.getIconName() + "'></vaadin-icon>${item.name}")).withProperty("name", Person::getName)).setHeader("Name");
        grid.addColumn((Renderer)LitRenderer.of((String)("<vaadin-icon icon='" + FontAwesome.Brands.VAADIN.getIconName() + "'></vaadin-icon>${item.age}")).withProperty("age", Person::getAge)).setHeader("Age");
        this.add(new Component[]{grid});
    }

    private class Person {
        int id;
        String name;
        int age;

        public Person(int id, String name, int age) {
            this.id = id;
            this.name = name;
            this.age = age;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public int getAge() {
            return this.age;
        }
    }
}

