/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.fontawesome;

import com.flowingcode.vaadin.addons.DemoLayout;
import com.flowingcode.vaadin.addons.fontawesome.FontAwesomeReflect;
import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H4;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.WildcardParameter;
import java.util.stream.Stream;
import org.junit.Ignore;

@Ignore
@Route(value="font-awesome-iron-iconset/view", layout=DemoLayout.class)
public class DemoViewSingle
extends Div
implements HasUrlParameter<String> {
    Object icon;

    public void setParameter(BeforeEvent event, @WildcardParameter String parameter) {
        this.addClassName("single-icon-view");
        String[] ss = parameter.split("/", 2);
        if (ss.length == 2) {
            String iconset = ss[0];
            String iconname = iconset + ":" + ss[1];
            this.icon = FontAwesomeReflect.getIconTypes().stream().filter(e -> FontAwesomeReflect.getIconset(e).equals(iconset)).flatMap(e -> Stream.of(e.getEnumConstants())).filter(_icon -> FontAwesomeReflect.getIconName(_icon).equals(iconname)).findFirst().orElse(null);
        } else {
            this.icon = null;
        }
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.icon != null) {
            H4 iconTitle = new H4("Icon");
            iconTitle.getStyle().set("margin", "1em");
            this.add(new Component[]{iconTitle});
            HorizontalLayout iconsLayout = new HorizontalLayout();
            iconsLayout.getStyle().set("margin", "2em");
            iconsLayout.setDefaultVerticalComponentAlignment(FlexComponent.Alignment.END);
            iconsLayout.add(new Component[]{FontAwesomeReflect.create(this.icon)});
            iconsLayout.add(new Component[]{FontAwesomeReflect.create(this.icon)});
            iconsLayout.add(new Component[]{FontAwesomeReflect.create(this.icon)});
            this.add(new Component[]{iconsLayout});
            VerticalLayout layout = new VerticalLayout();
            layout.add(new Component[]{new H4("Icon name")});
            layout.add(new Component[]{new Span(FontAwesomeReflect.getIconName(this.icon))});
            String type = "FontAwesome." + this.icon.getClass().getSimpleName();
            String name = ((Enum)this.icon).name();
            layout.add(new Component[]{new H4("Enum constant")});
            layout.add(new Component[]{new Span(type + "." + name)});
            layout.add(new Component[]{new H4("Java Example")});
            layout.add(new Component[]{new Span(String.format("add(%s.%s.create());", type, name))});
            this.add(new Component[]{layout});
        } else {
            this.add(new Component[]{new Span("Not found")});
        }
    }
}

