/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.vaadin.addons.carousel;

import com.flowingcode.vaadin.addons.carousel.Slide;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasTheme;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;

@Tag(value="fc-l2t-paper-slider")
@NpmPackage(value="@polymer/iron-a11y-keys-behavior", version="3.0.1")
@JsModule(value="./paper-slider/fc-l2t-paper-slider.js")
public class Carousel
extends Component
implements HasSize,
HasTheme {
    private static final String HIDE_NAV = "hideNav";
    private static final String DISABLE_SWIPE = "disableSwipe";
    private static final String POSITION = "position";
    private static final String SLIDE_DURATION = "slideDuration";
    private static final String AUTO_PROGRESS = "autoProgress";
    private static final int DEFAULT_SLIDE_DURATION = 2;
    private Slide[] slides;

    public Carousel(Slide ... paperSlides) {
        this.setSlides(paperSlides);
        this.initProperties();
    }

    private void updateSlides(Slide ... paperSlides) {
        for (Slide slide : paperSlides) {
            this.getElement().appendChild(new Element[]{slide.getElement()});
        }
    }

    private void initProperties() {
        this.setAutoProgress(false);
        this.setSlideDuration(2);
        this.setStartPosition(0);
        this.setDisableSwipe(false);
        this.setHideNavigation(false);
    }

    public Slide[] getSlides() {
        return this.slides;
    }

    public void setSlides(Slide[] slides) {
        this.slides = slides;
        this.updateSlides(slides);
    }

    public boolean isAutoProgress() {
        return this.getElement().getProperty(AUTO_PROGRESS, false);
    }

    public void setAutoProgress(boolean autoProgress) {
        this.getElement().setProperty(AUTO_PROGRESS, autoProgress);
    }

    public int getSlideDuration() {
        return this.getElement().getProperty(SLIDE_DURATION, 0);
    }

    public void setSlideDuration(int slideDuration) {
        this.getElement().setProperty(SLIDE_DURATION, (double)slideDuration);
    }

    public int getStartPosition() {
        return this.getElement().getProperty(POSITION, 0);
    }

    public void setStartPosition(int startPosition) {
        this.getElement().setProperty(POSITION, (double)startPosition);
    }

    public boolean isDisableSwipe() {
        return this.getElement().getProperty(DISABLE_SWIPE, false);
    }

    public void setDisableSwipe(boolean disableSwipe) {
        this.getElement().setProperty(DISABLE_SWIPE, disableSwipe);
    }

    public boolean isHideNavigation() {
        return this.getElement().getProperty(HIDE_NAV, false);
    }

    public void setHideNavigation(boolean hideNavigation) {
        this.getElement().setProperty(HIDE_NAV, hideNavigation);
    }

    public Carousel withAutoProgress() {
        this.setAutoProgress(true);
        return this;
    }

    public Carousel withoutSwipe() {
        this.setDisableSwipe(true);
        return this;
    }

    public Carousel withoutNavigation() {
        this.setHideNavigation(true);
        return this;
    }

    public Carousel withSlideDuration(int slideDuration) {
        this.setSlideDuration(slideDuration);
        return this;
    }

    public Carousel withStartPosition(int startPosition) {
        this.setStartPosition(startPosition);
        return this;
    }

    public void setHeight(String height) {
        super.setHeight(height);
        this.getElement().getStyle().set("--paper-slide-height", height);
    }

    public String getHeight() {
        return this.getElement().getStyle().get("--paper-slide-height");
    }

    public void moveNext() {
        this.getElement().callJsFunction("moveNext", new Serializable[0]);
    }

    public void movePrev() {
        this.getElement().callJsFunction("movePrev", new Serializable[0]);
    }

    public void movePos(int slide) {
        this.getElement().callJsFunction("movePos", new Serializable[]{"" + slide});
    }

    public Registration addChangeListener(ComponentEventListener<SlideChangeEvent> listener) {
        return this.addListener(SlideChangeEvent.class, listener);
    }

    @DomEvent(value="position-changed")
    public static class SlideChangeEvent
    extends ComponentEvent<Carousel> {
        private String position;

        public SlideChangeEvent(Carousel source, boolean fromClient, @EventData(value="event.detail.value") String position) {
            super((Component)source, fromClient);
            this.position = position;
        }

        public String getPosition() {
            return this.position;
        }
    }
}

