/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.applayout.endpoint;

import com.flowingcode.addons.applayout.MenuItem;
import com.flowingcode.addons.applayout.endpoint.MenuItemDto;
import com.flowingcode.addons.applayout.endpoint.MenuItemsProvider;
import com.vaadin.flow.server.auth.AnonymousAllowed;
import com.vaadin.hilla.Endpoint;
import com.vaadin.hilla.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@Endpoint
@AnonymousAllowed
public class MenuEndpoint {
    List<MenuItemsProvider> menuItemsProviders;

    public MenuEndpoint(List<MenuItemsProvider> menuItemsProviders) {
        this.menuItemsProviders = menuItemsProviders;
    }

    public @Nonnull List<@Nonnull MenuItemDto> getMenuItems() {
        List<MenuItem> menuItems = this.menuItemsProviders.stream().map(MenuItemsProvider::getMenuItems).flatMap(Collection::stream).collect(Collectors.toList());
        return this.convertMenuItems(menuItems);
    }

    private List<MenuItemDto> convertMenuItems(List<MenuItem> menuItems) {
        return menuItems.stream().map(mi -> new MenuItemDto(mi.getLabel(), mi.getHref(), this.extractMenuItems((MenuItem)mi))).collect(Collectors.toList());
    }

    private List<MenuItemDto> extractMenuItems(MenuItem mi) {
        return this.convertMenuItems(mi.getChildren().filter(MenuItem.class::isInstance).map(MenuItem.class::cast).collect(Collectors.toList()));
    }
}

