/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.applayout.menu;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.Text;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.Optional;

@NpmPackage(value="@polymer/paper-item", version="3.0.1")
@JsModule(value="@polymer/paper-item/paper-icon-item.js")
@Tag(value="paper-icon-item")
class PaperIconItem
extends Component
implements HasComponents,
HasText,
HasSize {
    private Icon icon;
    private Text text;

    public PaperIconItem(String title) {
        this.setText("");
        this.text = new Text(title);
        this.add(new Component[]{this.text});
    }

    public void addCommand(Command command) {
        if (command != null) {
            this.getElement().addEventListener("click", (DomEventListener & Serializable)e -> {
                command.execute();
                this.getElement().executeJs("this.dispatchEvent(new CustomEvent('item-clicked', {bubbles: true}))", new Serializable[0]);
            });
        }
    }

    public void setTitle(String title) {
        this.text.setText(title);
    }

    public void setIcon(String icon) {
        this.withIronIcon(icon != null).ifPresent(e -> {
            e.removeAttribute("src");
            e.setAttribute("icon", icon);
        });
    }

    public void setImage(String image) {
        this.withIronIcon(image != null).ifPresent(e -> {
            e.removeAttribute("icon");
            e.setAttribute("src", image);
        });
    }

    private Optional<Element> withIronIcon(boolean create) {
        if (create) {
            if (this.icon == null) {
                this.icon = new Icon("", "");
                this.icon.getElement().setAttribute("slot", "item-icon");
                this.add(new Component[]{this.icon});
            }
            return Optional.of(this.icon.getElement());
        }
        if (this.icon != null) {
            this.remove(new Component[]{this.icon});
            this.icon = null;
        }
        return Optional.empty();
    }
}

