/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.applayout.menu;

import com.flowingcode.addons.applayout.MenuItem;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.orderedlayout.ThemableLayout;
import com.vaadin.flow.dom.Element;
import java.util.ArrayList;

@NpmPackage(value="@polymer/paper-card", version="3.0.1")
@JsModule(value="@polymer/paper-card/paper-card.js")
@Tag(value="paper-card")
public class PaperCard
extends Component
implements HasSize,
HasStyle,
ThemableLayout {
    private final Div cardContentDiv = new Div();
    private final Div cardActionsDiv = new Div();
    private final HasComponents hasComponentsVersion = new HasComponents(){

        public Element getElement() {
            return PaperCard.this.getElement();
        }
    };

    public PaperCard() {
        this(null, new MenuItem[0]);
    }

    public PaperCard(Component cardContent, MenuItem ... cardActions) {
        this.cardContentDiv.setClassName("card-content");
        this.cardActionsDiv.setClassName("card-actions");
        this.hasComponentsVersion.add(new Component[]{this.cardContentDiv});
        if (cardContent != null) {
            this.setCardContent(cardContent);
        }
        this.setCardActions(cardActions);
    }

    public void setCardActions(MenuItem ... cardActions) {
        if (cardActions.length > 0) {
            ArrayList<MenuItem> buttons = new ArrayList<MenuItem>();
            for (MenuItem menuItem : cardActions) {
                if (menuItem.getIcon() != null) {
                    buttons.add(menuItem);
                    continue;
                }
                buttons.add(menuItem);
            }
            Div inner = new Div();
            this.cardActionsDiv.add(new Component[]{inner});
            inner.addClassNames(new String[]{"horizontal", "justified"});
            buttons.forEach(xva$0 -> inner.add(new Component[]{xva$0}));
            this.hasComponentsVersion.add(new Component[]{this.cardActionsDiv});
        }
    }

    public void setCardContent(Component content) {
        this.cardContentDiv.removeAll();
        this.cardContentDiv.add(new Component[]{content});
    }
}

