/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.applayout;

import com.flowingcode.addons.applayout.AppLayout;
import com.flowingcode.addons.applayout.DemoSettings;
import com.flowingcode.addons.applayout.InternalView;
import com.flowingcode.addons.applayout.MenuItem;
import com.flowingcode.addons.applayout.MenuSeparator;
import com.flowingcode.addons.applayout.MouseClickEvent;
import com.flowingcode.addons.applayout.ToolbarIconButton;
import com.flowingcode.addons.applayout.menu.PaperCard;
import com.flowingcode.addons.applayout.menu.PaperToggle;
import com.flowingcode.vaadin.addons.DemoLayout;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.dependency.StyleSheet;
import com.vaadin.flow.component.dialog.Dialog;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.H3;
import com.vaadin.flow.component.html.H5;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.IconFactory;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.server.Command;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.stream.Collectors;
import org.junit.Ignore;

@Route(value="applayout", layout=DemoLayout.class)
@StyleSheet(value="context://frontend/styles/app-layout/demo-styles.css")
@Ignore
public class ApplayoutDemoView
extends VerticalLayout {
    private VerticalLayout container = new VerticalLayout();
    private final AppLayout app = new AppLayout(this.createLogoImage(), this.createAvatarComponent(), "AppLayout Vaadin 23 Demo");
    private final ToolbarIconButton miSettings = new ToolbarIconButton("Settings", "settings", this::openSettings);
    private final DemoSettings settings = new DemoSettings();

    public ApplayoutDemoView() {
        this.container.setDefaultHorizontalComponentAlignment(FlexComponent.Alignment.CENTER);
        this.container.setSizeFull();
        this.setPadding(false);
        this.setSpacing(false);
        this.setMargin(false);
        this.app.setMenuItems(this.createMenuItems());
        this.app.setToolbarIconButtons(new Component[]{this.miSettings});
        this.app.add(new Component[]{this.container});
        this.add(new Component[]{this.app});
        this.settings.setSwipeOpen(true);
        this.settings.setMenuVisible(true);
        this.settings.setReveals(true);
        this.applySettings();
        this.showHamletContent();
    }

    private void applySettings() {
        this.app.setMenuVisible(this.settings.isMenuVisible());
        this.app.setSwipeOpen(this.settings.isSwipeOpen());
        this.app.setFixed(this.settings.isFixed());
        this.app.setReveals(this.settings.isReveals());
        this.app.setDrawerPersistent(this.settings.isDrawerPersistent());
        this.app.setDrawerBelowHeader(this.settings.isDrawerBelowHeader());
        this.app.setDrawerRightAlignment(this.settings.isDrawerRightAlignment());
        if (this.settings.isCompact()) {
            this.app.addClassName("compact");
        } else {
            this.app.removeClassName("compact");
        }
    }

    private void openSettings() {
        Dialog dialog = new Dialog();
        H3 title = new H3("Demo settings");
        title.getStyle().set("margin-top", "0");
        dialog.add(new Component[]{title});
        Checkbox cbMenuVisible = new Checkbox("Menu visible");
        Checkbox cbSwipeOpen = new Checkbox("Swipe Open");
        Checkbox cbFixed = new Checkbox("Fixed");
        Checkbox cbReveals = new Checkbox("Reveals");
        Checkbox cbCompact = new Checkbox("Compact");
        Checkbox cbPersistent = new Checkbox("Drawer Persistent");
        Checkbox cbBelowHeader = new Checkbox("Drawer Below Header");
        Checkbox cbRightAlignment = new Checkbox("Drawer Aligned to Right");
        cbMenuVisible.getElement().setAttribute("title", "Toggle visibility of the hamburguer icon.");
        cbSwipeOpen.getElement().setAttribute("title", "When enabled, you can open the menu by swiping the left border of the screen.");
        cbFixed.getElement().setAttribute("title", "When enabled, the header is fixed at the top so it never moves away.");
        cbReveals.getElement().setAttribute("title", "When enabled, the header slides back when scrolling back up.");
        cbCompact.getElement().setAttribute("title", "When enabled, the height of the header is set to 32px.");
        cbPersistent.getElement().setAttribute("title", "When enabled, the drawer will be opened in a non-modal way");
        cbBelowHeader.getElement().setAttribute("title", "When enabled, the drawer will be placed below the header");
        cbRightAlignment.getElement().setAttribute("title", "When enabled, the drawer will be right aligned");
        Binder binder = new Binder();
        binder.forField((HasValue)cbMenuVisible).bind(DemoSettings::isMenuVisible, DemoSettings::setMenuVisible);
        binder.forField((HasValue)cbSwipeOpen).bind(DemoSettings::isSwipeOpen, DemoSettings::setSwipeOpen);
        binder.forField((HasValue)cbFixed).bind(DemoSettings::isFixed, DemoSettings::setFixed);
        binder.forField((HasValue)cbReveals).bind(DemoSettings::isReveals, DemoSettings::setReveals);
        binder.forField((HasValue)cbCompact).bind(DemoSettings::isCompact, DemoSettings::setCompact);
        binder.forField((HasValue)cbPersistent).bind(DemoSettings::isDrawerPersistent, DemoSettings::setDrawerPersistent);
        binder.forField((HasValue)cbBelowHeader).bind(DemoSettings::isDrawerBelowHeader, DemoSettings::setDrawerBelowHeader);
        binder.forField((HasValue)cbRightAlignment).bind(DemoSettings::isDrawerRightAlignment, DemoSettings::setDrawerRightAlignment);
        binder.setBean((Object)this.settings);
        VerticalLayout content = new VerticalLayout(new Component[]{cbMenuVisible, cbSwipeOpen, cbFixed, cbReveals, cbCompact, cbPersistent, cbBelowHeader, cbRightAlignment});
        content.setSpacing(false);
        HorizontalLayout buttons = new HorizontalLayout();
        Button btnOk = new Button("OK", (ComponentEventListener & Serializable)ev -> {
            this.applySettings();
            dialog.close();
        });
        Button btnCancel = new Button("Cancel", (ComponentEventListener & Serializable)ev -> dialog.close());
        btnOk.getElement().setAttribute("theme", "primary");
        buttons.setSpacing(true);
        buttons.add(new Component[]{btnOk, btnCancel});
        buttons.setSpacing(true);
        dialog.add(new Component[]{content, buttons});
        dialog.setSizeUndefined();
        dialog.open();
    }

    private Image createLogoImage() {
        Image img = new Image("/frontend/images/applogo.png", "applogo");
        img.addClassName("applogo");
        return img;
    }

    private Component createAvatarComponent() {
        Div container = new Div();
        container.getElement().setAttribute("style", "text-align: center;");
        Image img = new Image("/frontend/images/avatar.png", "avatar");
        img.getStyle().set("width", "80px");
        img.getStyle().set("margin-top", "20px");
        Span userTitle = new Span("User");
        userTitle.setWidthFull();
        userTitle.getStyle().set("display", "block");
        userTitle.getStyle().set("font-size", "large");
        userTitle.getStyle().set("font-weight", "bold");
        container.add(new Component[]{img, userTitle});
        return container;
    }

    private void toggleSettings(MenuItem toggleSettings) {
        this.settings.setEnabled(!this.settings.isEnabled());
        this.miSettings.setEnabled(this.settings.isEnabled());
        this.app.setToolbarIconButtons(new Component[]{this.miSettings});
        if (this.settings.isEnabled()) {
            toggleSettings.setLabel("Disable settings");
        } else {
            toggleSettings.setLabel("Enable settings");
        }
    }

    private Component[] createMenuItems() {
        MenuItem miHello = (MenuItem)new MenuItem("More content", (Command & Serializable)() -> this.showContent("Hello!")).setIcon("settings");
        MenuItem miToggleSettings = (MenuItem)new MenuItem().setIcon("settings");
        miToggleSettings.setCommand((Command & Serializable)() -> this.toggleSettings(miToggleSettings));
        this.toggleSettings(miToggleSettings);
        this.getElement().getStyle().set("--icon-spacing", "normal");
        return new Component[]{((MenuItem)((MenuItem)new MenuItem("Click", (IconFactory)VaadinIcon.POINTER).setCommand(MouseClickEvent.MouseButton.LEFT, (Command & Serializable)() -> Notification.show((String)"LEFT click"))).setCommand(MouseClickEvent.MouseButton.MIDDLE, (Command & Serializable)() -> Notification.show((String)"MIDDLE click"))).setCommand(MouseClickEvent.MouseButton.RIGHT, (Command & Serializable)() -> Notification.show((String)"RIGHT click")), new MenuItem("No icon"), new MenuItem("No icon, spaced").configure(mi -> mi.setIconBlank()), new MenuItem("Toggle").configure(mi -> mi.add(new Component[]{new PaperToggle()})), new MenuItem("Toggle", (IconFactory)VaadinIcon.BACKSPACE).configure(mi -> mi.add(new Component[]{new PaperToggle()})), new MenuItem("Toggle", "fc-menuitem-icons:empty").configure(mi -> mi.add(new Component[]{new PaperToggle()})), new MenuItem("External link").setHref("http://www.google.com"), new MenuItem("Internal Link", InternalView.class), new MenuItem("Content", (IconFactory)VaadinIcon.BOOK, (Command & Serializable)() -> this.showHamletContent()).setCommand(MouseClickEvent.MouseButton.MIDDLE, (Command & Serializable)() -> this.getUI().ifPresent(ui -> ui.getPage().executeJs("window.open(window.location.href, '_blank')", new Serializable[0]))), miToggleSettings, miHello, new MenuItem("About", "cloud", (Command & Serializable)() -> this.showContent("About")), new MenuItem("Clear Items", "clear", (Command & Serializable)() -> this.app.clearMenuItems()), new MenuItem("Change Text & Icon", "cloud", (Command & Serializable)() -> {
            if (miHello.getIcon().equals("star")) {
                miHello.setIcon("cloud");
                miHello.setLabel("Say hello modified");
            } else {
                miHello.setIcon("star");
                miHello.setLabel("Say hello");
            }
        }), ((MenuItem)new MenuItem("SubMenu").setIcon("build")).setOpened(true).add(new MenuItem[]{new MenuItem("Hello Again", "inbox", (Command & Serializable)() -> this.showContent("Hello Again!")), new MenuItem("And Again", (Command & Serializable)() -> this.showContent("And Again!")), new MenuItem("SubMenu").setOpened(true).add(new MenuItem[]{new MenuItem("Hello Again", (Command & Serializable)() -> this.showContent("Hello Again!"))}).add(new MenuItem[]{new MenuItem("And Again", (Command & Serializable)() -> this.showContent("And Again!"))})}), new MenuSeparator("Separator"), new MenuItem("Item 1"), new MenuItem("Item 2"), new MenuItem("Item 3"), new MenuItem("Item 4"), new MenuItem("Item 5"), new MenuItem("Item 6"), new MenuSeparator(), new MenuItem("Item 7"), new MenuItem("Item 8"), new MenuItem("Item 9"), new MenuItem("Item 10"), new MenuItem("Item 11"), new MenuItem("Item 12")};
    }

    private void showContent(String content) {
        this.container.setClassName("");
        this.container.removeAll();
        H3 label = new H3();
        label.setSizeFull();
        label.setText(content);
        PaperCard pc = new PaperCard((Component)label, new MenuItem("Delete", (Command & Serializable)() -> Notification.show((String)"Delete action from card")), (MenuItem)new MenuItem("Delete", (Command & Serializable)() -> Notification.show((String)"Delete action from card")).setIcon("delete"));
        pc.setWidth("100%");
        this.container.add(new Component[]{pc});
    }

    private void showHamletContent() {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("hamlet");
        String text = new BufferedReader(new InputStreamReader(in)).lines().collect(Collectors.joining("\n"));
        this.container.removeAll();
        this.container.setClassName("hamlet");
        for (String block : text.split("\n\n")) {
            PaperCard card;
            if (block.startsWith("$")) continue;
            if (block.startsWith("[")) {
                card = new PaperCard();
                card.setCardContent((Component)new Span(block.substring(1, block.indexOf("]"))));
                card.getElement().setAttribute("elevation", "0");
                this.container.add(new Component[]{card});
                continue;
            }
            card = new PaperCard();
            String[] ss = block.split("\\.", 2);
            card.setCardContent((Component)new Div(new Component[]{new H5(ss[0]), new Span(ss[1])}));
            if (ss[0].equals("Claudius")) {
                this.container.setHorizontalComponentAlignment(FlexComponent.Alignment.END, new Component[]{card});
                card.addClassName("claudius");
            } else {
                this.container.setHorizontalComponentAlignment(FlexComponent.Alignment.START, new Component[]{card});
            }
            this.container.add(new Component[]{card});
        }
    }
}

