/*
 * Decompiled with CFR 0.152.
 */
package com.flowingcode.addons.applayout;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.JsModule;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Div;
import com.vaadin.flow.component.html.Image;
import com.vaadin.flow.router.RouterLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Tag(value="fc-applayout")
@JsModule(value="@flowingcode/fc-applayout/fc-applayout.js")
@NpmPackage(value="@flowingcode/fc-applayout", version="0.9.6")
@CssImport(value="./styles/applayout-styles.css", themeFor="fc-applayout")
public class AppLayout
extends Div
implements RouterLayout {
    private static final String PROFILE_SLOT_NAME = "profile";
    private static final String APP_LAYOUT_TITLE_SLOT_NAME = "title";
    private static final String TITLE_ATTRIBUTE_NAME = "title";
    private final List<Component> menuItems = new ArrayList<Component>();
    private final List<Component> toolbarComponents = new ArrayList<Component>();

    public AppLayout() {
        this(null, "", null);
    }

    public AppLayout(String title) {
        this(null, title, null);
    }

    public AppLayout(Component menuHeader, String title) {
        this(menuHeader, title, null);
    }

    public AppLayout(Image logo, Component menuHeader, String title) {
        this(menuHeader, title, logo);
    }

    private AppLayout(Component menuHeader, String aTitle, Image aLogo) {
        if (aLogo != null) {
            this.addToTitleSection((Component)aLogo);
        }
        if (menuHeader != null) {
            this.setMenuHeader(menuHeader);
        }
        Div title = new Div();
        title.setText(aTitle);
        this.addToTitleSection((Component)title);
        this.setDrawerRightAlignment(false);
    }

    public void addToTitleSection(Component component) {
        component.getElement().setAttribute("slot", "title");
        this.add(new Component[]{component});
    }

    public void setMenuHeader(Component menuHeader) {
        this.getChildren().filter(item -> PROFILE_SLOT_NAME.equals(item.getElement().getAttribute("slot"))).forEach(xva$0 -> this.remove(new Component[]{xva$0}));
        menuHeader.getElement().setAttribute("slot", PROFILE_SLOT_NAME);
        this.add(new Component[]{menuHeader});
    }

    public void setMenuItems(Component ... someMenuitems) {
        this.menuItems.addAll(Arrays.asList(someMenuitems));
        this.menuItems.forEach(item -> item.getElement().setAttribute("slot", "menu"));
        this.add(someMenuitems);
    }

    public void clearMenuItems() {
        this.getChildren().forEach(item -> {
            if (this.menuItems.contains(item)) {
                this.remove(new Component[]{item});
            }
        });
        this.menuItems.clear();
    }

    public void setToolbarIconButtons(Component ... components) {
        this.toolbarComponents.forEach(xva$0 -> this.remove(new Component[]{xva$0}));
        this.addToolbarIconButtons(components);
    }

    public void addToolbarIconButtons(Component ... components) {
        List<Component> componentsToAdd = Arrays.asList(components);
        componentsToAdd.forEach(comp -> comp.getElement().setAttribute("slot", "toolbar"));
        this.toolbarComponents.addAll(componentsToAdd);
        this.add(components);
    }

    public void addToolbarIconButtonAsFirst(Component component) {
        this.toolbarComponents.add(0, component);
        this.toolbarComponents.forEach(xva$0 -> this.remove(new Component[]{xva$0}));
        this.addToolbarIconButtons(this.toolbarComponents.toArray(new Component[this.toolbarComponents.size()]));
    }

    public void clearToolbarIconButtons() {
        this.toolbarComponents.forEach(xva$0 -> this.remove(new Component[]{xva$0}));
        this.toolbarComponents.clear();
    }

    public void setMenuVisible(boolean visible) {
        this.getElement().setProperty("drawerVisible", visible);
    }

    public boolean isMenuVisible() {
        return this.getElement().getProperty("drawerVisible", true);
    }

    public void setCaption(String caption) {
        this.getElement().setAttribute("title", caption);
    }

    public void setFixed(boolean fixed) {
        this.getElement().setAttribute("fixed", fixed);
    }

    public void setReveals(boolean reveals) {
        this.getElement().setAttribute("reveals", reveals);
    }

    public void setSwipeOpen(boolean swipeOpen) {
        this.getElement().setAttribute("swipeOpen", swipeOpen);
    }

    public void setDrawerPersistent(boolean drawerPersistent) {
        this.getElement().setAttribute("drawerPersistent", drawerPersistent);
    }

    public void setDrawerBelowHeader(boolean drawerBelowHeader) {
        this.getElement().setAttribute("drawerBelowHeader", drawerBelowHeader);
    }

    public void setDrawerRightAlignment(boolean drawerRightAlignment) {
        this.getElement().setAttribute("drawerAlign", drawerRightAlignment ? "right" : "left");
    }
}

